@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents the workflow health.
 * @property error Gets or sets the workflow error.
 * @property state Gets or sets the workflow health state.
 */
public data class WorkflowHealthResponse(
    public val error: ErrorEntityResponse? = null,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.WorkflowHealthResponse): WorkflowHealthResponse = WorkflowHealthResponse(
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ErrorEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state(),
        )
    }
}
