@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets the workflow trigger callback URL query parameters.
 * @property apiVersion The api version.
 * @property se The SAS timestamp.
 * @property sig The SAS signature.
 * @property sp The SAS permissions.
 * @property sv The SAS version.
 */
public data class WorkflowTriggerListCallbackUrlQueriesResponse(
    public val apiVersion: String? = null,
    public val se: String? = null,
    public val sig: String? = null,
    public val sp: String? = null,
    public val sv: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.WorkflowTriggerListCallbackUrlQueriesResponse): WorkflowTriggerListCallbackUrlQueriesResponse =
            WorkflowTriggerListCallbackUrlQueriesResponse(
                apiVersion = javaType.apiVersion().map({ args0 -> args0 }).orElse(null),
                se = javaType.se().map({ args0 -> args0 }).orElse(null),
                sig = javaType.sig().map({ args0 -> args0 }).orElse(null),
                sp = javaType.sp().map({ args0 -> args0 }).orElse(null),
                sv = javaType.sv().map({ args0 -> args0 }).orElse(null),
            )
    }
}
