@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.WebPubSubCustomDomainArgs.builder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A custom domain
 * Azure REST API version: 2023-02-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### WebPubSubCustomDomains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSubCustomDomain = new AzureNative.WebPubSub.WebPubSubCustomDomain("webPubSubCustomDomain", new()
 *     {
 *         CustomCertificate = new AzureNative.WebPubSub.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/WebPubSub/myWebPubSubService/customCertificates/myCert",
 *         },
 *         DomainName = "example.com",
 *         Name = "myDomain",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSubCustomDomain(ctx, "webPubSubCustomDomain", &webpubsub.WebPubSubCustomDomainArgs{
 * 			CustomCertificate: &webpubsub.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/WebPubSub/myWebPubSubService/customCertificates/myCert"),
 * 			},
 * 			DomainName:        pulumi.String("example.com"),
 * 			Name:              pulumi.String("myDomain"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("myWebPubSubService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSubCustomDomain;
 * import com.pulumi.azurenative.webpubsub.WebPubSubCustomDomainArgs;
 * import com.pulumi.azurenative.webpubsub.inputs.ResourceReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSubCustomDomain = new WebPubSubCustomDomain("webPubSubCustomDomain", WebPubSubCustomDomainArgs.builder()
 *             .customCertificate(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/WebPubSub/myWebPubSubService/customCertificates/myCert")
 *                 .build())
 *             .domainName("example.com")
 *             .name("myDomain")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSubCustomDomain myDomain /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}/customDomains/{name}
 * ```
 * @property customCertificate Reference to a resource.
 * @property domainName The custom domain name.
 * @property name Custom domain name.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 */
public data class WebPubSubCustomDomainArgs(
    public val customCertificate: Output<ResourceReferenceArgs>? = null,
    public val domainName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.WebPubSubCustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.WebPubSubCustomDomainArgs =
        com.pulumi.azurenative.webpubsub.WebPubSubCustomDomainArgs.builder()
            .customCertificate(customCertificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebPubSubCustomDomainArgs].
 */
@PulumiTagMarker
public class WebPubSubCustomDomainArgsBuilder internal constructor() {
    private var customCertificate: Output<ResourceReferenceArgs>? = null

    private var domainName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Reference to a resource.
     */
    @JvmName("ikmrtwlutjgcusnl")
    public suspend fun customCertificate(`value`: Output<ResourceReferenceArgs>) {
        this.customCertificate = value
    }

    /**
     * @param value The custom domain name.
     */
    @JvmName("vyjbdtstwnrkpotm")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Custom domain name.
     */
    @JvmName("tseejppsybtmboyu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rolkeevqhjsjiivf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("fgddxwkgklecdplr")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Reference to a resource.
     */
    @JvmName("demvytqjubqlubbd")
    public suspend fun customCertificate(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customCertificate = mapped
    }

    /**
     * @param argument Reference to a resource.
     */
    @JvmName("btkkbkrhnohtdhyn")
    public suspend fun customCertificate(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customCertificate = mapped
    }

    /**
     * @param value The custom domain name.
     */
    @JvmName("jqdsarutjejuialg")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Custom domain name.
     */
    @JvmName("btgsbbycyimfavog")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rqieikhouraofvgw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("wsscvioihdcitdxv")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): WebPubSubCustomDomainArgs = WebPubSubCustomDomainArgs(
        customCertificate = customCertificate,
        domainName = domainName,
        name = name,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
