@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubHubPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubHubPropertiesResponse.Companion.toKotlin as webPubSubHubPropertiesResponseToKotlin

/**
 * Builder for [WebPubSubHub].
 */
@PulumiTagMarker
public class WebPubSubHubResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebPubSubHubArgs = WebPubSubHubArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebPubSubHubArgsBuilder.() -> Unit) {
        val builder = WebPubSubHubArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebPubSubHub {
        val builtJavaResource = com.pulumi.azurenative.webpubsub.WebPubSubHub(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebPubSubHub(builtJavaResource)
    }
}

/**
 * A hub setting
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### WebPubSubHubs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSubHub = new AzureNative.WebPubSub.WebPubSubHub("webPubSubHub", new()
 *     {
 *         HubName = "exampleHub",
 *         Properties = new AzureNative.WebPubSub.Inputs.WebPubSubHubPropertiesArgs
 *         {
 *             AnonymousConnectPolicy = "allow",
 *             EventHandlers = new[]
 *             {
 *                 new AzureNative.WebPubSub.Inputs.EventHandlerArgs
 *                 {
 *                     Auth = new AzureNative.WebPubSub.Inputs.UpstreamAuthSettingsArgs
 *                     {
 *                         ManagedIdentity = new AzureNative.WebPubSub.Inputs.ManagedIdentitySettingsArgs
 *                         {
 *                             Resource = "abc",
 *                         },
 *                         Type = AzureNative.WebPubSub.UpstreamAuthType.ManagedIdentity,
 *                     },
 *                     SystemEvents = new[]
 *                     {
 *                         "connect",
 *                         "connected",
 *                     },
 *                     UrlTemplate = "http://host.com",
 *                     UserEventPattern = "*",
 *                 },
 *             },
 *             EventListeners = new[]
 *             {
 *                 new AzureNative.WebPubSub.Inputs.EventListenerArgs
 *                 {
 *                     Endpoint = new AzureNative.WebPubSub.Inputs.EventHubEndpointArgs
 *                     {
 *                         EventHubName = "eventHubName1",
 *                         FullyQualifiedNamespace = "example.servicebus.windows.net",
 *                         Type = "EventHub",
 *                     },
 *                     Filter = new AzureNative.WebPubSub.Inputs.EventNameFilterArgs
 *                     {
 *                         SystemEvents = new[]
 *                         {
 *                             "connected",
 *                             "disconnected",
 *                         },
 *                         Type = "EventName",
 *                         UserEventPattern = "*",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSubHub(ctx, "webPubSubHub", &webpubsub.WebPubSubHubArgs{
 * 			HubName: pulumi.String("exampleHub"),
 * 			Properties: &webpubsub.WebPubSubHubPropertiesArgs{
 * 				AnonymousConnectPolicy: pulumi.String("allow"),
 * 				EventHandlers: webpubsub.EventHandlerArray{
 * 					&webpubsub.EventHandlerArgs{
 * 						Auth: &webpubsub.UpstreamAuthSettingsArgs{
 * 							ManagedIdentity: &webpubsub.ManagedIdentitySettingsArgs{
 * 								Resource: pulumi.String("abc"),
 * 							},
 * 							Type: pulumi.String(webpubsub.UpstreamAuthTypeManagedIdentity),
 * 						},
 * 						SystemEvents: pulumi.StringArray{
 * 							pulumi.String("connect"),
 * 							pulumi.String("connected"),
 * 						},
 * 						UrlTemplate:      pulumi.String("http://host.com"),
 * 						UserEventPattern: pulumi.String("*"),
 * 					},
 * 				},
 * 				EventListeners: []webpubsub.EventListenerArgs{
 * 					{
 * 						Endpoint: {
 * 							EventHubName:            pulumi.String("eventHubName1"),
 * 							FullyQualifiedNamespace: pulumi.String("example.servicebus.windows.net"),
 * 							Type:                    pulumi.String("EventHub"),
 * 						},
 * 						Filter: {
 * 							SystemEvents: pulumi.StringArray{
 * 								pulumi.String("connected"),
 * 								pulumi.String("disconnected"),
 * 							},
 * 							Type:             pulumi.String("EventName"),
 * 							UserEventPattern: pulumi.String("*"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("myWebPubSubService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSubHub;
 * import com.pulumi.azurenative.webpubsub.WebPubSubHubArgs;
 * import com.pulumi.azurenative.webpubsub.inputs.WebPubSubHubPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSubHub = new WebPubSubHub("webPubSubHub", WebPubSubHubArgs.builder()
 *             .hubName("exampleHub")
 *             .properties(WebPubSubHubPropertiesArgs.builder()
 *                 .anonymousConnectPolicy("allow")
 *                 .eventHandlers(EventHandlerArgs.builder()
 *                     .auth(UpstreamAuthSettingsArgs.builder()
 *                         .managedIdentity(ManagedIdentitySettingsArgs.builder()
 *                             .resource("abc")
 *                             .build())
 *                         .type("ManagedIdentity")
 *                         .build())
 *                     .systemEvents(
 *                         "connect",
 *                         "connected")
 *                     .urlTemplate("http://host.com")
 *                     .userEventPattern("*")
 *                     .build())
 *                 .eventListeners(EventListenerArgs.builder()
 *                     .endpoint(EventHubEndpointArgs.builder()
 *                         .eventHubName("eventHubName1")
 *                         .fullyQualifiedNamespace("example.servicebus.windows.net")
 *                         .type("EventHub")
 *                         .build())
 *                     .filter(EventNameFilterArgs.builder()
 *                         .systemEvents(
 *                             "connected",
 *                             "disconnected")
 *                         .type("EventName")
 *                         .userEventPattern("*")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSubHub exampleHub /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}/hubs/{hubName}
 * ```
 */
public class WebPubSubHub internal constructor(
    override val javaResource: com.pulumi.azurenative.webpubsub.WebPubSubHub,
) : KotlinCustomResource(javaResource, WebPubSubHubMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of a hub.
     */
    public val properties: Output<WebPubSubHubPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                webPubSubHubPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebPubSubHubMapper : ResourceMapper<WebPubSubHub> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.webpubsub.WebPubSubHub::class == javaResource::class

    override fun map(javaResource: Resource): WebPubSubHub = WebPubSubHub(
        javaResource as
            com.pulumi.azurenative.webpubsub.WebPubSubHub,
    )
}

/**
 * @see [WebPubSubHub].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebPubSubHub].
 */
public suspend fun webPubSubHub(
    name: String,
    block: suspend WebPubSubHubResourceBuilder.() -> Unit,
): WebPubSubHub {
    val builder = WebPubSubHubResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebPubSubHub].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webPubSubHub(name: String): WebPubSubHub {
    val builder = WebPubSubHubResourceBuilder()
    builder.name(name)
    return builder.build()
}
