@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubHubPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The hub name.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 */
public data class GetWebPubSubHubPlainArgs(
    public val hubName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubHubPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubHubPlainArgs =
        com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubHubPlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebPubSubHubPlainArgs].
 */
@PulumiTagMarker
public class GetWebPubSubHubPlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The hub name.
     */
    @JvmName("psxawnksnebfmukc")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sepmaknnmkjlaybp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("mlatdlqtdiuuffrc")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetWebPubSubHubPlainArgs = GetWebPubSubHubPlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
