@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Event Hub endpoint.
 * The managed identity of Web PubSub service must be enabled, and the identity should have the "Azure Event Hubs Data sender" role to access Event Hub.
 * @property eventHubName The name of the Event Hub.
 * @property fullyQualifiedNamespace The fully qualified namespace name of the Event Hub resource. For example, "example.servicebus.windows.net".
 * @property type
 * Expected value is 'EventHub'.
 */
public data class EventHubEndpointResponse(
    public val eventHubName: String,
    public val fullyQualifiedNamespace: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.EventHubEndpointResponse): EventHubEndpointResponse = EventHubEndpointResponse(
            eventHubName = javaType.eventHubName(),
            fullyQualifiedNamespace = javaType.fullyQualifiedNamespace(),
            type = javaType.type(),
        )
    }
}
