@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A private endpoint connection to an azure resource
 * @property groupIds Group IDs
 * @property id Fully qualified resource Id for the resource.
 * @property name The name of the resource.
 * @property privateEndpoint Private endpoint
 * @property privateLinkServiceConnectionState Connection state of the private endpoint connection
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
 */
public data class GetWebPubSubPrivateEndpointConnectionResult(
    public val groupIds: List<String>,
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.GetWebPubSubPrivateEndpointConnectionResult): GetWebPubSubPrivateEndpointConnectionResult = GetWebPubSubPrivateEndpointConnectionResult(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
