@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network ACL
 * @property allow Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 * @property deny Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 */
public data class NetworkACLResponse(
    public val allow: List<String>? = null,
    public val deny: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.NetworkACLResponse): NetworkACLResponse = NetworkACLResponse(
            allow = javaType.allow().map({ args0 -> args0 }),
            deny = javaType.deny().map({ args0 -> args0 }),
        )
    }
}
