@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource log category configuration of a Microsoft.SignalRService resource.
 * @property enabled Indicates whether or the resource log category is enabled.
 * Available values: true, false.
 * Case insensitive.
 * @property name Gets or sets the resource log category's name.
 * Available values: ConnectivityLogs, MessagingLogs.
 * Case insensitive.
 */
public data class ResourceLogCategoryResponse(
    public val enabled: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.ResourceLogCategoryResponse): ResourceLogCategoryResponse = ResourceLogCategoryResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
