@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Resource log configuration of a Microsoft.SignalRService resource.
 * @property categories Gets or sets the list of category configurations.
 */
public data class ResourceLogConfigurationResponse(
    public val categories: List<ResourceLogCategoryResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.ResourceLogConfigurationResponse): ResourceLogConfigurationResponse = ResourceLogConfigurationResponse(
            categories = javaType.categories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceLogCategoryResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
