@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a Shared Private Link Resource
 * @property groupId The group id from the provider of resource the shared private link resource is for
 * @property id Fully qualified resource Id for the resource.
 * @property name The name of the resource.
 * @property privateLinkResourceId The resource id of the resource the shared private link resource is for
 * @property provisioningState Provisioning state of the resource.
 * @property requestMessage The request message for requesting approval of the shared private link resource
 * @property status Status of the shared private link resource
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
 */
public data class SharedPrivateLinkResourceResponse(
    public val groupId: String,
    public val id: String,
    public val name: String,
    public val privateLinkResourceId: String,
    public val provisioningState: String,
    public val requestMessage: String? = null,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.SharedPrivateLinkResourceResponse): SharedPrivateLinkResourceResponse = SharedPrivateLinkResourceResponse(
            groupId = javaType.groupId(),
            id = javaType.id(),
            name = javaType.name(),
            privateLinkResourceId = javaType.privateLinkResourceId(),
            provisioningState = javaType.provisioningState(),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
