@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Upstream auth settings. If not set, no auth is used for upstream messages.
 * @property managedIdentity Managed identity settings for upstream.
 * @property type Upstream auth type enum.
 */
public data class UpstreamAuthSettingsResponse(
    public val managedIdentity: ManagedIdentitySettingsResponse? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.UpstreamAuthSettingsResponse): UpstreamAuthSettingsResponse = UpstreamAuthSettingsResponse(
            managedIdentity = javaType.managedIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.ManagedIdentitySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
