@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a hub.
 * @property anonymousConnectPolicy The settings for configuring if anonymous connections are allowed for this hub: "allow" or "deny". Default to "deny".
 * @property eventHandlers Event handler of a hub.
 * @property eventListeners Event listener settings for forwarding your client events to listeners.
 * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
 * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
 * Maximum count of event listeners among all hubs is 10.
 */
public data class WebPubSubHubPropertiesResponse(
    public val anonymousConnectPolicy: String? = null,
    public val eventHandlers: List<EventHandlerResponse>? = null,
    public val eventListeners: List<EventListenerResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.WebPubSubHubPropertiesResponse): WebPubSubHubPropertiesResponse = WebPubSubHubPropertiesResponse(
            anonymousConnectPolicy = javaType.anonymousConnectPolicy().map({ args0 -> args0 }).orElse(null),
            eventHandlers = javaType.eventHandlers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.EventHandlerResponse.Companion.toKotlin(args0)
                })
            }),
            eventListeners = javaType.eventListeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.EventListenerResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
