@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * TLS settings for the resource
 * @property clientCertEnabled Request client certificate during TLS handshake if enabled
 */
public data class WebPubSubTlsSettingsResponse(
    public val clientCertEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.WebPubSubTlsSettingsResponse): WebPubSubTlsSettingsResponse = WebPubSubTlsSettingsResponse(
            clientCertEnabled = javaType.clientCertEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
