@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsesu.kotlin

import com.pulumi.azurenative.windowsesu.WindowsesuFunctions.getMultipleActivationKeyPlain
import com.pulumi.azurenative.windowsesu.kotlin.inputs.GetMultipleActivationKeyPlainArgs
import com.pulumi.azurenative.windowsesu.kotlin.inputs.GetMultipleActivationKeyPlainArgsBuilder
import com.pulumi.azurenative.windowsesu.kotlin.outputs.GetMultipleActivationKeyResult
import com.pulumi.azurenative.windowsesu.kotlin.outputs.GetMultipleActivationKeyResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object WindowsesuFunctions {
    /**
     * Get a MAK key.
     * Azure REST API version: 2019-09-16-preview.
     * @param argument null
     * @return MAK key details.
     */
    public suspend fun getMultipleActivationKey(argument: GetMultipleActivationKeyPlainArgs): GetMultipleActivationKeyResult =
        toKotlin(getMultipleActivationKeyPlain(argument.toJava()).await())

    /**
     * @see [getMultipleActivationKey].
     * @param multipleActivationKeyName The name of the MAK key.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MAK key details.
     */
    public suspend fun getMultipleActivationKey(
        multipleActivationKeyName: String,
        resourceGroupName: String,
    ): GetMultipleActivationKeyResult {
        val argument = GetMultipleActivationKeyPlainArgs(
            multipleActivationKeyName = multipleActivationKeyName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getMultipleActivationKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getMultipleActivationKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;windowsesu&#46;kotlin&#46;inputs&#46;GetMultipleActivationKeyPlainArgs].
     * @return MAK key details.
     */
    public suspend fun getMultipleActivationKey(argument: suspend GetMultipleActivationKeyPlainArgsBuilder.() -> Unit): GetMultipleActivationKeyResult {
        val builder = GetMultipleActivationKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getMultipleActivationKeyPlain(builtArgument.toJava()).await())
    }
}
