@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsesu.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of OS for which the key is requested.
 */
public enum class OsType(
    public val javaValue: com.pulumi.azurenative.windowsesu.enums.OsType,
) : ConvertibleToJava<com.pulumi.azurenative.windowsesu.enums.OsType> {
    Windows7(com.pulumi.azurenative.windowsesu.enums.OsType.Windows7),
    WindowsServer2008(com.pulumi.azurenative.windowsesu.enums.OsType.WindowsServer2008),
    WindowsServer2008R2(com.pulumi.azurenative.windowsesu.enums.OsType.WindowsServer2008R2),
    ;

    override fun toJava(): com.pulumi.azurenative.windowsesu.enums.OsType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.windowsesu.enums.OsType): OsType =
            OsType.values().first { it.javaValue == javaType }
    }
}
