@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsesu.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * MAK key details.
 * @property agreementNumber Agreement number under which the key is requested.
 * @property expirationDate End of support of security updates activated by the MAK key.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property installedServerNumber Number of activations/servers using the MAK key.
 * @property isEligible <code> true </code> if user has eligible on-premises Windows physical or virtual machines, and that the requested key will only be used in their organization; <code> false </code> otherwise.
 * @property location The geo-location where the resource lives
 * @property multipleActivationKey MAK 5x5 key.
 * @property name The name of the resource
 * @property osType Type of OS for which the key is requested.
 * @property provisioningState
 * @property supportType Type of support
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMultipleActivationKeyResult(
    public val agreementNumber: String? = null,
    public val expirationDate: String,
    public val id: String,
    public val installedServerNumber: Int? = null,
    public val isEligible: Boolean? = null,
    public val location: String,
    public val multipleActivationKey: String,
    public val name: String,
    public val osType: String? = null,
    public val provisioningState: String,
    public val supportType: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.windowsesu.outputs.GetMultipleActivationKeyResult): GetMultipleActivationKeyResult = GetMultipleActivationKeyResult(
            agreementNumber = javaType.agreementNumber().map({ args0 -> args0 }).orElse(null),
            expirationDate = javaType.expirationDate(),
            id = javaType.id(),
            installedServerNumber = javaType.installedServerNumber().map({ args0 -> args0 }).orElse(null),
            isEligible = javaType.isEligible().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            multipleActivationKey = javaType.multipleActivationKey(),
            name = javaType.name(),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            supportType = javaType.supportType().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
