@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsiot.kotlin

import com.pulumi.azurenative.windowsiot.ServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of the Windows IoT Device Service.
 * Azure REST API version: 2019-06-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2018-02-16-preview.
 * ## Example Usage
 * ### Service_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.WindowsIoT.Service("service", new()
 *     {
 *         AdminDomainName = "d.e.f",
 *         BillingDomainName = "a.b.c",
 *         DeviceName = "service4445",
 *         Location = "East US",
 *         Notes = "blah",
 *         Quantity = 1000000,
 *         ResourceGroupName = "res9101",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/windowsiot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := windowsiot.NewService(ctx, "service", &windowsiot.ServiceArgs{
 * 			AdminDomainName:   pulumi.String("d.e.f"),
 * 			BillingDomainName: pulumi.String("a.b.c"),
 * 			DeviceName:        pulumi.String("service4445"),
 * 			Location:          pulumi.String("East US"),
 * 			Notes:             pulumi.String("blah"),
 * 			Quantity:          pulumi.Float64(1000000),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.windowsiot.Service;
 * import com.pulumi.azurenative.windowsiot.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .adminDomainName("d.e.f")
 *             .billingDomainName("a.b.c")
 *             .deviceName("service4445")
 *             .location("East US")
 *             .notes("blah")
 *             .quantity(1000000)
 *             .resourceGroupName("res9101")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:windowsiot:Service myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsIoT/deviceServices/{deviceName}
 * ```
 * @property adminDomainName Windows IoT Device Service OEM AAD domain
 * @property billingDomainName Windows IoT Device Service ODM AAD domain
 * @property deviceName The name of the Windows IoT Device Service.
 * @property location The Azure Region where the resource lives
 * @property notes Windows IoT Device Service notes.
 * @property quantity Windows IoT Device Service device allocation,
 * @property resourceGroupName The name of the resource group that contains the Windows IoT Device Service.
 * @property tags Resource tags.
 */
public data class ServiceArgs(
    public val adminDomainName: Output<String>? = null,
    public val billingDomainName: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val quantity: Output<Double>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.windowsiot.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.windowsiot.ServiceArgs =
        com.pulumi.azurenative.windowsiot.ServiceArgs.builder()
            .adminDomainName(adminDomainName?.applyValue({ args0 -> args0 }))
            .billingDomainName(billingDomainName?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .quantity(quantity?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var adminDomainName: Output<String>? = null

    private var billingDomainName: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var location: Output<String>? = null

    private var notes: Output<String>? = null

    private var quantity: Output<Double>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Windows IoT Device Service OEM AAD domain
     */
    @JvmName("bokncjrkajdmuscc")
    public suspend fun adminDomainName(`value`: Output<String>) {
        this.adminDomainName = value
    }

    /**
     * @param value Windows IoT Device Service ODM AAD domain
     */
    @JvmName("vxqkbcvtufvrvuap")
    public suspend fun billingDomainName(`value`: Output<String>) {
        this.billingDomainName = value
    }

    /**
     * @param value The name of the Windows IoT Device Service.
     */
    @JvmName("tkguvmuokuvuxfcy")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The Azure Region where the resource lives
     */
    @JvmName("cwqlbqahjvimmvce")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Windows IoT Device Service notes.
     */
    @JvmName("ekxssyxufscroiih")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value Windows IoT Device Service device allocation,
     */
    @JvmName("fhwioxkdyooslitj")
    public suspend fun quantity(`value`: Output<Double>) {
        this.quantity = value
    }

    /**
     * @param value The name of the resource group that contains the Windows IoT Device Service.
     */
    @JvmName("kfgvtpyrkcyedhpv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ejpolsukbnjypfpf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Windows IoT Device Service OEM AAD domain
     */
    @JvmName("elqstnbiyryfqkcc")
    public suspend fun adminDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminDomainName = mapped
    }

    /**
     * @param value Windows IoT Device Service ODM AAD domain
     */
    @JvmName("hsdekorwgquxkqfe")
    public suspend fun billingDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingDomainName = mapped
    }

    /**
     * @param value The name of the Windows IoT Device Service.
     */
    @JvmName("rwucrdtcmbvufgwa")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The Azure Region where the resource lives
     */
    @JvmName("cqaqxnotbqknilgh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Windows IoT Device Service notes.
     */
    @JvmName("cpfedhrfkjrwvxut")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value Windows IoT Device Service device allocation,
     */
    @JvmName("xgwblahsdykemjer")
    public suspend fun quantity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quantity = mapped
    }

    /**
     * @param value The name of the resource group that contains the Windows IoT Device Service.
     */
    @JvmName("afijlflkxsxjtxvw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tmvqntkkpkqgcnuq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cvixwiywtqdwjgjt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        adminDomainName = adminDomainName,
        billingDomainName = billingDomainName,
        deviceName = deviceName,
        location = location,
        notes = notes,
        quantity = quantity,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
