@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsiot.kotlin

import com.pulumi.azurenative.windowsiot.WindowsiotFunctions.getServicePlain
import com.pulumi.azurenative.windowsiot.kotlin.inputs.GetServicePlainArgs
import com.pulumi.azurenative.windowsiot.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.azurenative.windowsiot.kotlin.outputs.GetServiceResult
import com.pulumi.azurenative.windowsiot.kotlin.outputs.GetServiceResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object WindowsiotFunctions {
    /**
     * Get the non-security related metadata of a Windows IoT Device Service.
     * Azure REST API version: 2019-06-01.
     * Other available API versions: 2018-02-16-preview.
     * @param argument null
     * @return The description of the Windows IoT Device Service.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        toKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param deviceName The name of the Windows IoT Device Service.
     * @param resourceGroupName The name of the resource group that contains the Windows IoT Device Service.
     * @return The description of the Windows IoT Device Service.
     */
    public suspend fun getService(deviceName: String, resourceGroupName: String): GetServiceResult {
        val argument = GetServicePlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;windowsiot&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return The description of the Windows IoT Device Service.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
