@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsiot.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The description of the Windows IoT Device Service.
 * @property adminDomainName Windows IoT Device Service OEM AAD domain
 * @property billingDomainName Windows IoT Device Service ODM AAD domain
 * @property etag The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
 * @property id Fully qualified resource Id for the resource
 * @property location The Azure Region where the resource lives
 * @property name The name of the resource
 * @property notes Windows IoT Device Service notes.
 * @property quantity Windows IoT Device Service device allocation,
 * @property startDate Windows IoT Device Service start date,
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetServiceResult(
    public val adminDomainName: String? = null,
    public val billingDomainName: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val notes: String? = null,
    public val quantity: Double? = null,
    public val startDate: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.windowsiot.outputs.GetServiceResult): GetServiceResult = GetServiceResult(
            adminDomainName = javaType.adminDomainName().map({ args0 -> args0 }).orElse(null),
            billingDomainName = javaType.billingDomainName().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            quantity = javaType.quantity().map({ args0 -> args0 }).orElse(null),
            startDate = javaType.startDate(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
