@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.MonitorArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.RoutingPreference
import com.pulumi.azurenative.workloads.kotlin.inputs.ManagedRGConfigurationArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.ManagedRGConfigurationArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.UserAssignedServiceIdentityArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.UserAssignedServiceIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SAP monitor info on Azure (ARM properties and SAP monitor properties)
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2023-12-01-preview.
 * ## Example Usage
 * ### Create a SAP monitor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitor = new AzureNative.Workloads.Monitor("monitor", new()
 *     {
 *         AppLocation = "westus",
 *         Location = "westus",
 *         LogAnalyticsWorkspaceArmId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace",
 *         ManagedResourceGroupConfiguration = new AzureNative.Workloads.Inputs.ManagedRGConfigurationArgs
 *         {
 *             Name = "myManagedRg",
 *         },
 *         MonitorName = "mySapMonitor",
 *         MonitorSubnet = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         ResourceGroupName = "myResourceGroup",
 *         RoutingPreference = AzureNative.Workloads.RoutingPreference.RouteAll,
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewMonitor(ctx, "monitor", &workloads.MonitorArgs{
 * 			AppLocation:                pulumi.String("westus"),
 * 			Location:                   pulumi.String("westus"),
 * 			LogAnalyticsWorkspaceArmId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace"),
 * 			ManagedResourceGroupConfiguration: &workloads.ManagedRGConfigurationArgs{
 * 				Name: pulumi.String("myManagedRg"),
 * 			},
 * 			MonitorName:       pulumi.String("mySapMonitor"),
 * 			MonitorSubnet:     pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RoutingPreference: pulumi.String(workloads.RoutingPreferenceRouteAll),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.Monitor;
 * import com.pulumi.azurenative.workloads.MonitorArgs;
 * import com.pulumi.azurenative.workloads.inputs.ManagedRGConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitor = new Monitor("monitor", MonitorArgs.builder()
 *             .appLocation("westus")
 *             .location("westus")
 *             .logAnalyticsWorkspaceArmId("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace")
 *             .managedResourceGroupConfiguration(ManagedRGConfigurationArgs.builder()
 *                 .name("myManagedRg")
 *                 .build())
 *             .monitorName("mySapMonitor")
 *             .monitorSubnet("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet")
 *             .resourceGroupName("myResourceGroup")
 *             .routingPreference("RouteAll")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:Monitor mySapMonitor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/monitors/{monitorName}
 * ```
 * @property appLocation The SAP monitor resources will be deployed in the SAP monitoring region. The subnet region should be same as the SAP monitoring region.
 * @property identity [currently not in use] Managed service identity(user assigned identities)
 * @property location The geo-location where the resource lives
 * @property logAnalyticsWorkspaceArmId The ARM ID of the Log Analytics Workspace that is used for SAP monitoring.
 * @property managedResourceGroupConfiguration Managed resource group configuration
 * @property monitorName Name of the SAP monitor resource.
 * @property monitorSubnet The subnet which the SAP monitor will be deployed in
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property routingPreference Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
 * @property tags Resource tags.
 * @property zoneRedundancyPreference Sets the preference for zone redundancy on resources created for the SAP monitor. By default resources will be created which do not support zone redundancy.
 */
public data class MonitorArgs(
    public val appLocation: Output<String>? = null,
    public val identity: Output<UserAssignedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val logAnalyticsWorkspaceArmId: Output<String>? = null,
    public val managedResourceGroupConfiguration: Output<ManagedRGConfigurationArgs>? = null,
    public val monitorName: Output<String>? = null,
    public val monitorSubnet: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingPreference: Output<Either<String, RoutingPreference>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneRedundancyPreference: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.MonitorArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.MonitorArgs =
        com.pulumi.azurenative.workloads.MonitorArgs.builder()
            .appLocation(appLocation?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .logAnalyticsWorkspaceArmId(logAnalyticsWorkspaceArmId?.applyValue({ args0 -> args0 }))
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .monitorSubnet(monitorSubnet?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingPreference(
                routingPreference?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneRedundancyPreference(zoneRedundancyPreference?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitorArgs].
 */
@PulumiTagMarker
public class MonitorArgsBuilder internal constructor() {
    private var appLocation: Output<String>? = null

    private var identity: Output<UserAssignedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var logAnalyticsWorkspaceArmId: Output<String>? = null

    private var managedResourceGroupConfiguration: Output<ManagedRGConfigurationArgs>? = null

    private var monitorName: Output<String>? = null

    private var monitorSubnet: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingPreference: Output<Either<String, RoutingPreference>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneRedundancyPreference: Output<String>? = null

    /**
     * @param value The SAP monitor resources will be deployed in the SAP monitoring region. The subnet region should be same as the SAP monitoring region.
     */
    @JvmName("hqvmmusqmqgfvnxn")
    public suspend fun appLocation(`value`: Output<String>) {
        this.appLocation = value
    }

    /**
     * @param value [currently not in use] Managed service identity(user assigned identities)
     */
    @JvmName("ittnuvlflaggyhdu")
    public suspend fun identity(`value`: Output<UserAssignedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hmmykrfyiuroyask")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The ARM ID of the Log Analytics Workspace that is used for SAP monitoring.
     */
    @JvmName("ilsiwjdpqxysayom")
    public suspend fun logAnalyticsWorkspaceArmId(`value`: Output<String>) {
        this.logAnalyticsWorkspaceArmId = value
    }

    /**
     * @param value Managed resource group configuration
     */
    @JvmName("gchngqlsfhlpdsob")
    public suspend fun managedResourceGroupConfiguration(`value`: Output<ManagedRGConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("wkbmydetdkwtrckt")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value The subnet which the SAP monitor will be deployed in
     */
    @JvmName("xqtnokuhehwhldbg")
    public suspend fun monitorSubnet(`value`: Output<String>) {
        this.monitorSubnet = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jrlfhunaimkhcogv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
     */
    @JvmName("dnpeymttgqeogpvx")
    public suspend fun routingPreference(`value`: Output<Either<String, RoutingPreference>>) {
        this.routingPreference = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jquvniencsbocdhp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Sets the preference for zone redundancy on resources created for the SAP monitor. By default resources will be created which do not support zone redundancy.
     */
    @JvmName("vpirtapopucbmkrv")
    public suspend fun zoneRedundancyPreference(`value`: Output<String>) {
        this.zoneRedundancyPreference = value
    }

    /**
     * @param value The SAP monitor resources will be deployed in the SAP monitoring region. The subnet region should be same as the SAP monitoring region.
     */
    @JvmName("uqiullnqnmipdhvn")
    public suspend fun appLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appLocation = mapped
    }

    /**
     * @param value [currently not in use] Managed service identity(user assigned identities)
     */
    @JvmName("erhswpwuenasgqgb")
    public suspend fun identity(`value`: UserAssignedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument [currently not in use] Managed service identity(user assigned identities)
     */
    @JvmName("amgeusaxkyomyvfe")
    public suspend fun identity(argument: suspend UserAssignedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cgaijfhbsruhvxxc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The ARM ID of the Log Analytics Workspace that is used for SAP monitoring.
     */
    @JvmName("lymfunkrmuvwlmkp")
    public suspend fun logAnalyticsWorkspaceArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsWorkspaceArmId = mapped
    }

    /**
     * @param value Managed resource group configuration
     */
    @JvmName("opqqrhxncaqdtrct")
    public suspend fun managedResourceGroupConfiguration(`value`: ManagedRGConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument Managed resource group configuration
     */
    @JvmName("obxgiusykhuvjgmc")
    public suspend fun managedResourceGroupConfiguration(argument: suspend ManagedRGConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedRGConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("xvldwwlwopgijefh")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value The subnet which the SAP monitor will be deployed in
     */
    @JvmName("mbkdbyvnsagfvoqr")
    public suspend fun monitorSubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorSubnet = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hrsmihidfjwpmseo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
     */
    @JvmName("agyckdgtnfeiidlq")
    public suspend fun routingPreference(`value`: Either<String, RoutingPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingPreference = mapped
    }

    /**
     * @param value Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
     */
    @JvmName("whawhxvfsbmapjyh")
    public fun routingPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoutingPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingPreference = mapped
    }

    /**
     * @param value Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
     */
    @JvmName("exwpixdukwagkkrs")
    public fun routingPreference(`value`: RoutingPreference) {
        val toBeMapped = Either.ofRight<String, RoutingPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingPreference = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bingwgogsvqthcdm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ymjrwrsvtwgrdltp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Sets the preference for zone redundancy on resources created for the SAP monitor. By default resources will be created which do not support zone redundancy.
     */
    @JvmName("ygqywuxjdnhgohpr")
    public suspend fun zoneRedundancyPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundancyPreference = mapped
    }

    internal fun build(): MonitorArgs = MonitorArgs(
        appLocation = appLocation,
        identity = identity,
        location = location,
        logAnalyticsWorkspaceArmId = logAnalyticsWorkspaceArmId,
        managedResourceGroupConfiguration = managedResourceGroupConfiguration,
        monitorName = monitorName,
        monitorSubnet = monitorSubnet,
        resourceGroupName = resourceGroupName,
        routingPreference = routingPreference,
        tags = tags,
        zoneRedundancyPreference = zoneRedundancyPreference,
    )
}
