@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.ProviderInstancePropertiesResponseErrors
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.workloads.kotlin.outputs.ProviderInstancePropertiesResponseErrors.Companion.toKotlin as providerInstancePropertiesResponseErrorsToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse.Companion.toKotlin as userAssignedServiceIdentityResponseToKotlin

/**
 * Builder for [ProviderInstance].
 */
@PulumiTagMarker
public class ProviderInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProviderInstanceArgs = ProviderInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProviderInstanceArgsBuilder.() -> Unit) {
        val builder = ProviderInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProviderInstance {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.ProviderInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProviderInstance(builtJavaResource)
    }
}

/**
 * A provider instance associated with SAP monitor.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create a Db2 provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.DB2ProviderInstancePropertiesArgs
 *         {
 *             DbName = "dbName",
 *             DbPassword = "password",
 *             DbPasswordUri = "",
 *             DbPort = "dbPort",
 *             DbUsername = "username",
 *             Hostname = "hostname",
 *             ProviderType = "Db2",
 *             SapSid = "SID",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.DB2ProviderInstanceProperties{
 * 				DbName:            "dbName",
 * 				DbPassword:        "password",
 * 				DbPasswordUri:     "",
 * 				DbPort:            "dbPort",
 * 				DbUsername:        "username",
 * 				Hostname:          "hostname",
 * 				ProviderType:      "Db2",
 * 				SapSid:            "SID",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(DB2ProviderInstancePropertiesArgs.builder()
 *                 .dbName("dbName")
 *                 .dbPassword("password")
 *                 .dbPasswordUri("")
 *                 .dbPort("dbPort")
 *                 .dbUsername("username")
 *                 .hostname("hostname")
 *                 .providerType("Db2")
 *                 .sapSid("SID")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Db2 provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.DB2ProviderInstancePropertiesArgs
 *         {
 *             DbName = "dbName",
 *             DbPassword = "password",
 *             DbPasswordUri = "",
 *             DbPort = "dbPort",
 *             DbUsername = "username",
 *             Hostname = "hostname",
 *             ProviderType = "Db2",
 *             SapSid = "SID",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.DB2ProviderInstanceProperties{
 * 				DbName:        "dbName",
 * 				DbPassword:    "password",
 * 				DbPasswordUri: "",
 * 				DbPort:        "dbPort",
 * 				DbUsername:    "username",
 * 				Hostname:      "hostname",
 * 				ProviderType:  "Db2",
 * 				SapSid:        "SID",
 * 				SslPreference: workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(DB2ProviderInstancePropertiesArgs.builder()
 *                 .dbName("dbName")
 *                 .dbPassword("password")
 *                 .dbPasswordUri("")
 *                 .dbPort("dbPort")
 *                 .dbUsername("username")
 *                 .hostname("hostname")
 *                 .providerType("Db2")
 *                 .sapSid("SID")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a MsSqlServer provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.MsSqlServerProviderInstancePropertiesArgs
 *         {
 *             DbPassword = "****",
 *             DbPasswordUri = "",
 *             DbPort = "5912",
 *             DbUsername = "user",
 *             Hostname = "hostname",
 *             ProviderType = "MsSqlServer",
 *             SapSid = "sid",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.MsSqlServerProviderInstanceProperties{
 * 				DbPassword:        "****",
 * 				DbPasswordUri:     "",
 * 				DbPort:            "5912",
 * 				DbUsername:        "user",
 * 				Hostname:          "hostname",
 * 				ProviderType:      "MsSqlServer",
 * 				SapSid:            "sid",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(MsSqlServerProviderInstancePropertiesArgs.builder()
 *                 .dbPassword("****")
 *                 .dbPasswordUri("")
 *                 .dbPort("5912")
 *                 .dbUsername("user")
 *                 .hostname("hostname")
 *                 .providerType("MsSqlServer")
 *                 .sapSid("sid")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a MsSqlServer provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.MsSqlServerProviderInstancePropertiesArgs
 *         {
 *             DbPassword = "****",
 *             DbPasswordUri = "",
 *             DbPort = "5912",
 *             DbUsername = "user",
 *             Hostname = "hostname",
 *             ProviderType = "MsSqlServer",
 *             SapSid = "sid",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.MsSqlServerProviderInstanceProperties{
 * 				DbPassword:    "****",
 * 				DbPasswordUri: "",
 * 				DbPort:        "5912",
 * 				DbUsername:    "user",
 * 				Hostname:      "hostname",
 * 				ProviderType:  "MsSqlServer",
 * 				SapSid:        "sid",
 * 				SslPreference: workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(MsSqlServerProviderInstancePropertiesArgs.builder()
 *                 .dbPassword("****")
 *                 .dbPasswordUri("")
 *                 .dbPort("5912")
 *                 .dbUsername("user")
 *                 .hostname("hostname")
 *                 .providerType("MsSqlServer")
 *                 .sapSid("sid")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a OS provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.PrometheusOSProviderInstancePropertiesArgs
 *         {
 *             PrometheusUrl = "http://192.168.0.0:9090/metrics",
 *             ProviderType = "PrometheusOS",
 *             SapSid = "SID",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.PrometheusOSProviderInstanceProperties{
 * 				PrometheusUrl:     "http://192.168.0.0:9090/metrics",
 * 				ProviderType:      "PrometheusOS",
 * 				SapSid:            "SID",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(PrometheusOSProviderInstancePropertiesArgs.builder()
 *                 .prometheusUrl("http://192.168.0.0:9090/metrics")
 *                 .providerType("PrometheusOS")
 *                 .sapSid("SID")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a OS provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.PrometheusOSProviderInstancePropertiesArgs
 *         {
 *             PrometheusUrl = "http://192.168.0.0:9090/metrics",
 *             ProviderType = "PrometheusOS",
 *             SapSid = "SID",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.PrometheusOSProviderInstanceProperties{
 * 				PrometheusUrl: "http://192.168.0.0:9090/metrics",
 * 				ProviderType:  "PrometheusOS",
 * 				SapSid:        "SID",
 * 				SslPreference: workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(PrometheusOSProviderInstancePropertiesArgs.builder()
 *                 .prometheusUrl("http://192.168.0.0:9090/metrics")
 *                 .providerType("PrometheusOS")
 *                 .sapSid("SID")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a PrometheusHaCluster provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.PrometheusHaClusterProviderInstancePropertiesArgs
 *         {
 *             ClusterName = "clusterName",
 *             Hostname = "hostname",
 *             PrometheusUrl = "http://192.168.0.0:9090/metrics",
 *             ProviderType = "PrometheusHaCluster",
 *             Sid = "sid",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.PrometheusHaClusterProviderInstanceProperties{
 * 				ClusterName:       "clusterName",
 * 				Hostname:          "hostname",
 * 				PrometheusUrl:     "http://192.168.0.0:9090/metrics",
 * 				ProviderType:      "PrometheusHaCluster",
 * 				Sid:               "sid",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(PrometheusHaClusterProviderInstancePropertiesArgs.builder()
 *                 .clusterName("clusterName")
 *                 .hostname("hostname")
 *                 .prometheusUrl("http://192.168.0.0:9090/metrics")
 *                 .providerType("PrometheusHaCluster")
 *                 .sid("sid")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a PrometheusHaCluster provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.PrometheusHaClusterProviderInstancePropertiesArgs
 *         {
 *             ClusterName = "clusterName",
 *             Hostname = "hostname",
 *             PrometheusUrl = "http://192.168.0.0:9090/metrics",
 *             ProviderType = "PrometheusHaCluster",
 *             Sid = "sid",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.PrometheusHaClusterProviderInstanceProperties{
 * 				ClusterName:   "clusterName",
 * 				Hostname:      "hostname",
 * 				PrometheusUrl: "http://192.168.0.0:9090/metrics",
 * 				ProviderType:  "PrometheusHaCluster",
 * 				Sid:           "sid",
 * 				SslPreference: workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(PrometheusHaClusterProviderInstancePropertiesArgs.builder()
 *                 .clusterName("clusterName")
 *                 .hostname("hostname")
 *                 .prometheusUrl("http://192.168.0.0:9090/metrics")
 *                 .providerType("PrometheusHaCluster")
 *                 .sid("sid")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SAP monitor Hana provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.HanaDbProviderInstancePropertiesArgs
 *         {
 *             DbName = "db",
 *             DbPassword = "****",
 *             DbPasswordUri = "",
 *             DbUsername = "user",
 *             Hostname = "name",
 *             InstanceNumber = "00",
 *             ProviderType = "SapHana",
 *             SapSid = "SID",
 *             SqlPort = "0000",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslHostNameInCertificate = "xyz.domain.com",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.HanaDbProviderInstanceProperties{
 * 				DbName:                   "db",
 * 				DbPassword:               "****",
 * 				DbPasswordUri:            "",
 * 				DbUsername:               "user",
 * 				Hostname:                 "name",
 * 				InstanceNumber:           "00",
 * 				ProviderType:             "SapHana",
 * 				SapSid:                   "SID",
 * 				SqlPort:                  "0000",
 * 				SslCertificateUri:        "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslHostNameInCertificate: "xyz.domain.com",
 * 				SslPreference:            workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(DB2ProviderInstancePropertiesArgs.builder()
 *                 .dbName("db")
 *                 .dbPassword("****")
 *                 .dbPasswordUri("")
 *                 .dbUsername("user")
 *                 .hostname("name")
 *                 .instanceNumber("00")
 *                 .providerType("SapHana")
 *                 .sapSid("SID")
 *                 .sqlPort("0000")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslHostNameInCertificate("xyz.domain.com")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SAP monitor Hana provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.HanaDbProviderInstancePropertiesArgs
 *         {
 *             DbName = "db",
 *             DbPassword = "****",
 *             DbPasswordUri = "",
 *             DbUsername = "user",
 *             Hostname = "name",
 *             InstanceNumber = "00",
 *             ProviderType = "SapHana",
 *             SapSid = "SID",
 *             SqlPort = "0000",
 *             SslHostNameInCertificate = "xyz.domain.com",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.HanaDbProviderInstanceProperties{
 * 				DbName:                   "db",
 * 				DbPassword:               "****",
 * 				DbPasswordUri:            "",
 * 				DbUsername:               "user",
 * 				Hostname:                 "name",
 * 				InstanceNumber:           "00",
 * 				ProviderType:             "SapHana",
 * 				SapSid:                   "SID",
 * 				SqlPort:                  "0000",
 * 				SslHostNameInCertificate: "xyz.domain.com",
 * 				SslPreference:            workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(DB2ProviderInstancePropertiesArgs.builder()
 *                 .dbName("db")
 *                 .dbPassword("****")
 *                 .dbPasswordUri("")
 *                 .dbUsername("user")
 *                 .hostname("name")
 *                 .instanceNumber("00")
 *                 .providerType("SapHana")
 *                 .sapSid("SID")
 *                 .sqlPort("0000")
 *                 .sslHostNameInCertificate("xyz.domain.com")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SAP monitor NetWeaver provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.SapNetWeaverProviderInstancePropertiesArgs
 *         {
 *             ProviderType = "SapNetWeaver",
 *             SapClientId = "111",
 *             SapHostFileEntries = new[]
 *             {
 *                 "127.0.0.1 name fqdn",
 *             },
 *             SapHostname = "name",
 *             SapInstanceNr = "00",
 *             SapPassword = "****",
 *             SapPasswordUri = "",
 *             SapPortNumber = "1234",
 *             SapSid = "SID",
 *             SapUsername = "username",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.SapNetWeaverProviderInstanceProperties{
 * 				ProviderType: "SapNetWeaver",
 * 				SapClientId:  "111",
 * 				SapHostFileEntries: []string{
 * 					"127.0.0.1 name fqdn",
 * 				},
 * 				SapHostname:       "name",
 * 				SapInstanceNr:     "00",
 * 				SapPassword:       "****",
 * 				SapPasswordUri:    "",
 * 				SapPortNumber:     "1234",
 * 				SapSid:            "SID",
 * 				SapUsername:       "username",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(SapNetWeaverProviderInstancePropertiesArgs.builder()
 *                 .providerType("SapNetWeaver")
 *                 .sapClientId("111")
 *                 .sapHostFileEntries("127.0.0.1 name fqdn")
 *                 .sapHostname("name")
 *                 .sapInstanceNr("00")
 *                 .sapPassword("****")
 *                 .sapPasswordUri("")
 *                 .sapPortNumber("1234")
 *                 .sapSid("SID")
 *                 .sapUsername("username")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SAP monitor NetWeaver provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.SapNetWeaverProviderInstancePropertiesArgs
 *         {
 *             ProviderType = "SapNetWeaver",
 *             SapClientId = "111",
 *             SapHostFileEntries = new[]
 *             {
 *                 "127.0.0.1 name fqdn",
 *             },
 *             SapHostname = "name",
 *             SapInstanceNr = "00",
 *             SapPassword = "****",
 *             SapPasswordUri = "",
 *             SapPortNumber = "1234",
 *             SapSid = "SID",
 *             SapUsername = "username",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.SapNetWeaverProviderInstanceProperties{
 * 				ProviderType: "SapNetWeaver",
 * 				SapClientId:  "111",
 * 				SapHostFileEntries: []string{
 * 					"127.0.0.1 name fqdn",
 * 				},
 * 				SapHostname:    "name",
 * 				SapInstanceNr:  "00",
 * 				SapPassword:    "****",
 * 				SapPasswordUri: "",
 * 				SapPortNumber:  "1234",
 * 				SapSid:         "SID",
 * 				SapUsername:    "username",
 * 				SslPreference:  workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(SapNetWeaverProviderInstancePropertiesArgs.builder()
 *                 .providerType("SapNetWeaver")
 *                 .sapClientId("111")
 *                 .sapHostFileEntries("127.0.0.1 name fqdn")
 *                 .sapHostname("name")
 *                 .sapInstanceNr("00")
 *                 .sapPassword("****")
 *                 .sapPasswordUri("")
 *                 .sapPortNumber("1234")
 *                 .sapSid("SID")
 *                 .sapUsername("username")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:ProviderInstance myProviderInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/monitors/{monitorName}/providerInstances/{providerInstanceName}
 * ```
 */
public class ProviderInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.ProviderInstance,
) : KotlinCustomResource(javaResource, ProviderInstanceMapper) {
    /**
     * Defines the provider instance errors.
     */
    public val errors: Output<ProviderInstancePropertiesResponseErrors>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                providerInstancePropertiesResponseErrorsToKotlin(args0)
            })
        })

    /**
     * [currently not in use] Managed service identity(user assigned identities)
     */
    public val identity: Output<UserAssignedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userAssignedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provider specific properties.
     */
    public val providerSettings: Output<Any>?
        get() = javaResource.providerSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * State of provisioning of the provider instance
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProviderInstanceMapper : ResourceMapper<ProviderInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.ProviderInstance::class == javaResource::class

    override fun map(javaResource: Resource): ProviderInstance = ProviderInstance(
        javaResource as
            com.pulumi.azurenative.workloads.ProviderInstance,
    )
}

/**
 * @see [ProviderInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProviderInstance].
 */
public suspend fun providerInstance(
    name: String,
    block: suspend ProviderInstanceResourceBuilder.() -> Unit,
): ProviderInstance {
    val builder = ProviderInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProviderInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun providerInstance(name: String): ProviderInstance {
    val builder = ProviderInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
