@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.ProviderInstanceArgs.builder
import com.pulumi.azurenative.workloads.kotlin.inputs.UserAssignedServiceIdentityArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.UserAssignedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A provider instance associated with SAP monitor.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create a Db2 provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.DB2ProviderInstancePropertiesArgs
 *         {
 *             DbName = "dbName",
 *             DbPassword = "password",
 *             DbPasswordUri = "",
 *             DbPort = "dbPort",
 *             DbUsername = "username",
 *             Hostname = "hostname",
 *             ProviderType = "Db2",
 *             SapSid = "SID",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.DB2ProviderInstanceProperties{
 * 				DbName:            "dbName",
 * 				DbPassword:        "password",
 * 				DbPasswordUri:     "",
 * 				DbPort:            "dbPort",
 * 				DbUsername:        "username",
 * 				Hostname:          "hostname",
 * 				ProviderType:      "Db2",
 * 				SapSid:            "SID",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(DB2ProviderInstancePropertiesArgs.builder()
 *                 .dbName("dbName")
 *                 .dbPassword("password")
 *                 .dbPasswordUri("")
 *                 .dbPort("dbPort")
 *                 .dbUsername("username")
 *                 .hostname("hostname")
 *                 .providerType("Db2")
 *                 .sapSid("SID")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Db2 provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.DB2ProviderInstancePropertiesArgs
 *         {
 *             DbName = "dbName",
 *             DbPassword = "password",
 *             DbPasswordUri = "",
 *             DbPort = "dbPort",
 *             DbUsername = "username",
 *             Hostname = "hostname",
 *             ProviderType = "Db2",
 *             SapSid = "SID",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.DB2ProviderInstanceProperties{
 * 				DbName:        "dbName",
 * 				DbPassword:    "password",
 * 				DbPasswordUri: "",
 * 				DbPort:        "dbPort",
 * 				DbUsername:    "username",
 * 				Hostname:      "hostname",
 * 				ProviderType:  "Db2",
 * 				SapSid:        "SID",
 * 				SslPreference: workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(DB2ProviderInstancePropertiesArgs.builder()
 *                 .dbName("dbName")
 *                 .dbPassword("password")
 *                 .dbPasswordUri("")
 *                 .dbPort("dbPort")
 *                 .dbUsername("username")
 *                 .hostname("hostname")
 *                 .providerType("Db2")
 *                 .sapSid("SID")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a MsSqlServer provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.MsSqlServerProviderInstancePropertiesArgs
 *         {
 *             DbPassword = "****",
 *             DbPasswordUri = "",
 *             DbPort = "5912",
 *             DbUsername = "user",
 *             Hostname = "hostname",
 *             ProviderType = "MsSqlServer",
 *             SapSid = "sid",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.MsSqlServerProviderInstanceProperties{
 * 				DbPassword:        "****",
 * 				DbPasswordUri:     "",
 * 				DbPort:            "5912",
 * 				DbUsername:        "user",
 * 				Hostname:          "hostname",
 * 				ProviderType:      "MsSqlServer",
 * 				SapSid:            "sid",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(MsSqlServerProviderInstancePropertiesArgs.builder()
 *                 .dbPassword("****")
 *                 .dbPasswordUri("")
 *                 .dbPort("5912")
 *                 .dbUsername("user")
 *                 .hostname("hostname")
 *                 .providerType("MsSqlServer")
 *                 .sapSid("sid")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a MsSqlServer provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.MsSqlServerProviderInstancePropertiesArgs
 *         {
 *             DbPassword = "****",
 *             DbPasswordUri = "",
 *             DbPort = "5912",
 *             DbUsername = "user",
 *             Hostname = "hostname",
 *             ProviderType = "MsSqlServer",
 *             SapSid = "sid",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.MsSqlServerProviderInstanceProperties{
 * 				DbPassword:    "****",
 * 				DbPasswordUri: "",
 * 				DbPort:        "5912",
 * 				DbUsername:    "user",
 * 				Hostname:      "hostname",
 * 				ProviderType:  "MsSqlServer",
 * 				SapSid:        "sid",
 * 				SslPreference: workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(MsSqlServerProviderInstancePropertiesArgs.builder()
 *                 .dbPassword("****")
 *                 .dbPasswordUri("")
 *                 .dbPort("5912")
 *                 .dbUsername("user")
 *                 .hostname("hostname")
 *                 .providerType("MsSqlServer")
 *                 .sapSid("sid")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a OS provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.PrometheusOSProviderInstancePropertiesArgs
 *         {
 *             PrometheusUrl = "http://192.168.0.0:9090/metrics",
 *             ProviderType = "PrometheusOS",
 *             SapSid = "SID",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.PrometheusOSProviderInstanceProperties{
 * 				PrometheusUrl:     "http://192.168.0.0:9090/metrics",
 * 				ProviderType:      "PrometheusOS",
 * 				SapSid:            "SID",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(PrometheusOSProviderInstancePropertiesArgs.builder()
 *                 .prometheusUrl("http://192.168.0.0:9090/metrics")
 *                 .providerType("PrometheusOS")
 *                 .sapSid("SID")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a OS provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.PrometheusOSProviderInstancePropertiesArgs
 *         {
 *             PrometheusUrl = "http://192.168.0.0:9090/metrics",
 *             ProviderType = "PrometheusOS",
 *             SapSid = "SID",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.PrometheusOSProviderInstanceProperties{
 * 				PrometheusUrl: "http://192.168.0.0:9090/metrics",
 * 				ProviderType:  "PrometheusOS",
 * 				SapSid:        "SID",
 * 				SslPreference: workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(PrometheusOSProviderInstancePropertiesArgs.builder()
 *                 .prometheusUrl("http://192.168.0.0:9090/metrics")
 *                 .providerType("PrometheusOS")
 *                 .sapSid("SID")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a PrometheusHaCluster provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.PrometheusHaClusterProviderInstancePropertiesArgs
 *         {
 *             ClusterName = "clusterName",
 *             Hostname = "hostname",
 *             PrometheusUrl = "http://192.168.0.0:9090/metrics",
 *             ProviderType = "PrometheusHaCluster",
 *             Sid = "sid",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.PrometheusHaClusterProviderInstanceProperties{
 * 				ClusterName:       "clusterName",
 * 				Hostname:          "hostname",
 * 				PrometheusUrl:     "http://192.168.0.0:9090/metrics",
 * 				ProviderType:      "PrometheusHaCluster",
 * 				Sid:               "sid",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(PrometheusHaClusterProviderInstancePropertiesArgs.builder()
 *                 .clusterName("clusterName")
 *                 .hostname("hostname")
 *                 .prometheusUrl("http://192.168.0.0:9090/metrics")
 *                 .providerType("PrometheusHaCluster")
 *                 .sid("sid")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a PrometheusHaCluster provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.PrometheusHaClusterProviderInstancePropertiesArgs
 *         {
 *             ClusterName = "clusterName",
 *             Hostname = "hostname",
 *             PrometheusUrl = "http://192.168.0.0:9090/metrics",
 *             ProviderType = "PrometheusHaCluster",
 *             Sid = "sid",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.PrometheusHaClusterProviderInstanceProperties{
 * 				ClusterName:   "clusterName",
 * 				Hostname:      "hostname",
 * 				PrometheusUrl: "http://192.168.0.0:9090/metrics",
 * 				ProviderType:  "PrometheusHaCluster",
 * 				Sid:           "sid",
 * 				SslPreference: workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(PrometheusHaClusterProviderInstancePropertiesArgs.builder()
 *                 .clusterName("clusterName")
 *                 .hostname("hostname")
 *                 .prometheusUrl("http://192.168.0.0:9090/metrics")
 *                 .providerType("PrometheusHaCluster")
 *                 .sid("sid")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SAP monitor Hana provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.HanaDbProviderInstancePropertiesArgs
 *         {
 *             DbName = "db",
 *             DbPassword = "****",
 *             DbPasswordUri = "",
 *             DbUsername = "user",
 *             Hostname = "name",
 *             InstanceNumber = "00",
 *             ProviderType = "SapHana",
 *             SapSid = "SID",
 *             SqlPort = "0000",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslHostNameInCertificate = "xyz.domain.com",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.HanaDbProviderInstanceProperties{
 * 				DbName:                   "db",
 * 				DbPassword:               "****",
 * 				DbPasswordUri:            "",
 * 				DbUsername:               "user",
 * 				Hostname:                 "name",
 * 				InstanceNumber:           "00",
 * 				ProviderType:             "SapHana",
 * 				SapSid:                   "SID",
 * 				SqlPort:                  "0000",
 * 				SslCertificateUri:        "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslHostNameInCertificate: "xyz.domain.com",
 * 				SslPreference:            workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(DB2ProviderInstancePropertiesArgs.builder()
 *                 .dbName("db")
 *                 .dbPassword("****")
 *                 .dbPasswordUri("")
 *                 .dbUsername("user")
 *                 .hostname("name")
 *                 .instanceNumber("00")
 *                 .providerType("SapHana")
 *                 .sapSid("SID")
 *                 .sqlPort("0000")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslHostNameInCertificate("xyz.domain.com")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SAP monitor Hana provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.HanaDbProviderInstancePropertiesArgs
 *         {
 *             DbName = "db",
 *             DbPassword = "****",
 *             DbPasswordUri = "",
 *             DbUsername = "user",
 *             Hostname = "name",
 *             InstanceNumber = "00",
 *             ProviderType = "SapHana",
 *             SapSid = "SID",
 *             SqlPort = "0000",
 *             SslHostNameInCertificate = "xyz.domain.com",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.HanaDbProviderInstanceProperties{
 * 				DbName:                   "db",
 * 				DbPassword:               "****",
 * 				DbPasswordUri:            "",
 * 				DbUsername:               "user",
 * 				Hostname:                 "name",
 * 				InstanceNumber:           "00",
 * 				ProviderType:             "SapHana",
 * 				SapSid:                   "SID",
 * 				SqlPort:                  "0000",
 * 				SslHostNameInCertificate: "xyz.domain.com",
 * 				SslPreference:            workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(DB2ProviderInstancePropertiesArgs.builder()
 *                 .dbName("db")
 *                 .dbPassword("****")
 *                 .dbPasswordUri("")
 *                 .dbUsername("user")
 *                 .hostname("name")
 *                 .instanceNumber("00")
 *                 .providerType("SapHana")
 *                 .sapSid("SID")
 *                 .sqlPort("0000")
 *                 .sslHostNameInCertificate("xyz.domain.com")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SAP monitor NetWeaver provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.SapNetWeaverProviderInstancePropertiesArgs
 *         {
 *             ProviderType = "SapNetWeaver",
 *             SapClientId = "111",
 *             SapHostFileEntries = new[]
 *             {
 *                 "127.0.0.1 name fqdn",
 *             },
 *             SapHostname = "name",
 *             SapInstanceNr = "00",
 *             SapPassword = "****",
 *             SapPasswordUri = "",
 *             SapPortNumber = "1234",
 *             SapSid = "SID",
 *             SapUsername = "username",
 *             SslCertificateUri = "https://storageaccount.blob.core.windows.net/containername/filename",
 *             SslPreference = AzureNative.Workloads.SslPreference.ServerCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.SapNetWeaverProviderInstanceProperties{
 * 				ProviderType: "SapNetWeaver",
 * 				SapClientId:  "111",
 * 				SapHostFileEntries: []string{
 * 					"127.0.0.1 name fqdn",
 * 				},
 * 				SapHostname:       "name",
 * 				SapInstanceNr:     "00",
 * 				SapPassword:       "****",
 * 				SapPasswordUri:    "",
 * 				SapPortNumber:     "1234",
 * 				SapSid:            "SID",
 * 				SapUsername:       "username",
 * 				SslCertificateUri: "https://storageaccount.blob.core.windows.net/containername/filename",
 * 				SslPreference:     workloads.SslPreferenceServerCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(SapNetWeaverProviderInstancePropertiesArgs.builder()
 *                 .providerType("SapNetWeaver")
 *                 .sapClientId("111")
 *                 .sapHostFileEntries("127.0.0.1 name fqdn")
 *                 .sapHostname("name")
 *                 .sapInstanceNr("00")
 *                 .sapPassword("****")
 *                 .sapPasswordUri("")
 *                 .sapPortNumber("1234")
 *                 .sapSid("SID")
 *                 .sapUsername("username")
 *                 .sslCertificateUri("https://storageaccount.blob.core.windows.net/containername/filename")
 *                 .sslPreference("ServerCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SAP monitor NetWeaver provider with Root Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.Workloads.ProviderInstance("providerInstance", new()
 *     {
 *         MonitorName = "mySapMonitor",
 *         ProviderInstanceName = "myProviderInstance",
 *         ProviderSettings = new AzureNative.Workloads.Inputs.SapNetWeaverProviderInstancePropertiesArgs
 *         {
 *             ProviderType = "SapNetWeaver",
 *             SapClientId = "111",
 *             SapHostFileEntries = new[]
 *             {
 *                 "127.0.0.1 name fqdn",
 *             },
 *             SapHostname = "name",
 *             SapInstanceNr = "00",
 *             SapPassword = "****",
 *             SapPasswordUri = "",
 *             SapPortNumber = "1234",
 *             SapSid = "SID",
 *             SapUsername = "username",
 *             SslPreference = AzureNative.Workloads.SslPreference.RootCertificate,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewProviderInstance(ctx, "providerInstance", &workloads.ProviderInstanceArgs{
 * 			MonitorName:          pulumi.String("mySapMonitor"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ProviderSettings: workloads.SapNetWeaverProviderInstanceProperties{
 * 				ProviderType: "SapNetWeaver",
 * 				SapClientId:  "111",
 * 				SapHostFileEntries: []string{
 * 					"127.0.0.1 name fqdn",
 * 				},
 * 				SapHostname:    "name",
 * 				SapInstanceNr:  "00",
 * 				SapPassword:    "****",
 * 				SapPasswordUri: "",
 * 				SapPortNumber:  "1234",
 * 				SapSid:         "SID",
 * 				SapUsername:    "username",
 * 				SslPreference:  workloads.SslPreferenceRootCertificate,
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ProviderInstance;
 * import com.pulumi.azurenative.workloads.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .monitorName("mySapMonitor")
 *             .providerInstanceName("myProviderInstance")
 *             .providerSettings(SapNetWeaverProviderInstancePropertiesArgs.builder()
 *                 .providerType("SapNetWeaver")
 *                 .sapClientId("111")
 *                 .sapHostFileEntries("127.0.0.1 name fqdn")
 *                 .sapHostname("name")
 *                 .sapInstanceNr("00")
 *                 .sapPassword("****")
 *                 .sapPasswordUri("")
 *                 .sapPortNumber("1234")
 *                 .sapSid("SID")
 *                 .sapUsername("username")
 *                 .sslPreference("RootCertificate")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:ProviderInstance myProviderInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/monitors/{monitorName}/providerInstances/{providerInstanceName}
 * ```
 * @property identity [currently not in use] Managed service identity(user assigned identities)
 * @property monitorName Name of the SAP monitor resource.
 * @property providerInstanceName Name of the provider instance.
 * @property providerSettings Defines the provider specific properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ProviderInstanceArgs(
    public val identity: Output<UserAssignedServiceIdentityArgs>? = null,
    public val monitorName: Output<String>? = null,
    public val providerInstanceName: Output<String>? = null,
    public val providerSettings: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.ProviderInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.ProviderInstanceArgs =
        com.pulumi.azurenative.workloads.ProviderInstanceArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .providerInstanceName(providerInstanceName?.applyValue({ args0 -> args0 }))
            .providerSettings(providerSettings?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderInstanceArgs].
 */
@PulumiTagMarker
public class ProviderInstanceArgsBuilder internal constructor() {
    private var identity: Output<UserAssignedServiceIdentityArgs>? = null

    private var monitorName: Output<String>? = null

    private var providerInstanceName: Output<String>? = null

    private var providerSettings: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value [currently not in use] Managed service identity(user assigned identities)
     */
    @JvmName("yafnfdbjukvjschf")
    public suspend fun identity(`value`: Output<UserAssignedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("namqdldffmstvtrh")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Name of the provider instance.
     */
    @JvmName("xvtaiiwbacyihhbi")
    public suspend fun providerInstanceName(`value`: Output<String>) {
        this.providerInstanceName = value
    }

    /**
     * @param value Defines the provider specific properties.
     */
    @JvmName("igcxyargeotdajvq")
    public suspend fun providerSettings(`value`: Output<Any>) {
        this.providerSettings = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("okapqptjbvvahkpt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value [currently not in use] Managed service identity(user assigned identities)
     */
    @JvmName("dokxbormaoyyklrx")
    public suspend fun identity(`value`: UserAssignedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument [currently not in use] Managed service identity(user assigned identities)
     */
    @JvmName("cesxbacfpgudvooo")
    public suspend fun identity(argument: suspend UserAssignedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("qbboimcnnvhotuyy")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Name of the provider instance.
     */
    @JvmName("mawtvaysptpeiuqb")
    public suspend fun providerInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerInstanceName = mapped
    }

    /**
     * @param value Defines the provider specific properties.
     */
    @JvmName("melveughhqqylgwa")
    public suspend fun providerSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerSettings = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nqaxghbfhkvhyifx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ProviderInstanceArgs = ProviderInstanceArgs(
        identity = identity,
        monitorName = monitorName,
        providerInstanceName = providerInstanceName,
        providerSettings = providerSettings,
        resourceGroupName = resourceGroupName,
    )
}
