@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.CentralServerVmDetailsResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.EnqueueReplicationServerPropertiesResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.EnqueueServerPropertiesResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.GatewayServerPropertiesResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.MessageServerPropertiesResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.CentralServerVmDetailsResponse.Companion.toKotlin as centralServerVmDetailsResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.EnqueueReplicationServerPropertiesResponse.Companion.toKotlin as enqueueReplicationServerPropertiesResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.EnqueueServerPropertiesResponse.Companion.toKotlin as enqueueServerPropertiesResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GatewayServerPropertiesResponse.Companion.toKotlin as gatewayServerPropertiesResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse.Companion.toKotlin as loadBalancerDetailsResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.MessageServerPropertiesResponse.Companion.toKotlin as messageServerPropertiesResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin as sAPVirtualInstanceErrorResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SAPCentralInstance].
 */
@PulumiTagMarker
public class SAPCentralInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SAPCentralInstanceArgs = SAPCentralInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SAPCentralInstanceArgsBuilder.() -> Unit) {
        val builder = SAPCentralInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SAPCentralInstance {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.SAPCentralInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SAPCentralInstance(builtJavaResource)
    }
}

/**
 * Define the SAP Central Services Instance resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create SAP Central Instances for HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapCentralInstance = new AzureNative.Workloads.SAPCentralInstance("sapCentralInstance", new()
 *     {
 *         CentralInstanceName = "centralServer",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPCentralInstance(ctx, "sapCentralInstance", &workloads.SAPCentralInstanceArgs{
 * 			CentralInstanceName:    pulumi.String("centralServer"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPCentralInstance;
 * import com.pulumi.azurenative.workloads.SAPCentralInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapCentralInstance = new SAPCentralInstance("sapCentralInstance", SAPCentralInstanceArgs.builder()
 *             .centralInstanceName("centralServer")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### SAPCentralInstances_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapCentralInstance = new AzureNative.Workloads.SAPCentralInstance("sapCentralInstance", new()
 *     {
 *         CentralInstanceName = "centralServer",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPCentralInstance(ctx, "sapCentralInstance", &workloads.SAPCentralInstanceArgs{
 * 			CentralInstanceName:    pulumi.String("centralServer"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPCentralInstance;
 * import com.pulumi.azurenative.workloads.SAPCentralInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapCentralInstance = new SAPCentralInstance("sapCentralInstance", SAPCentralInstanceArgs.builder()
 *             .centralInstanceName("centralServer")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SAPCentralInstance centralServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/centralInstances/{centralInstanceName}
 * ```
 */
public class SAPCentralInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.SAPCentralInstance,
) : KotlinCustomResource(javaResource, SAPCentralInstanceMapper) {
    /**
     * Defines the SAP Enqueue Replication Server (ERS) properties.
     */
    public val enqueueReplicationServerProperties: Output<EnqueueReplicationServerPropertiesResponse>?
        get() = javaResource.enqueueReplicationServerProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    enqueueReplicationServerPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Defines the SAP Enqueue Server properties.
     */
    public val enqueueServerProperties: Output<EnqueueServerPropertiesResponse>?
        get() = javaResource.enqueueServerProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> enqueueServerPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Defines the errors related to SAP Central Services Instance resource.
     */
    public val errors: Output<SAPVirtualInstanceErrorResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                sAPVirtualInstanceErrorResponseToKotlin(args0)
            })
        })

    /**
     * Defines the SAP Gateway Server properties.
     */
    public val gatewayServerProperties: Output<GatewayServerPropertiesResponse>?
        get() = javaResource.gatewayServerProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gatewayServerPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Defines the health of SAP Instances.
     */
    public val health: Output<String>
        get() = javaResource.health().applyValue({ args0 -> args0 })

    /**
     * The central services instance number.
     */
    public val instanceNo: Output<String>
        get() = javaResource.instanceNo().applyValue({ args0 -> args0 })

    /**
     * The central services instance Kernel Patch level.
     */
    public val kernelPatch: Output<String>
        get() = javaResource.kernelPatch().applyValue({ args0 -> args0 })

    /**
     * The central services instance Kernel Version.
     */
    public val kernelVersion: Output<String>
        get() = javaResource.kernelVersion().applyValue({ args0 -> args0 })

    /**
     * The Load Balancer details such as LoadBalancer ID attached to ASCS Virtual Machines
     */
    public val loadBalancerDetails: Output<LoadBalancerDetailsResponse>
        get() = javaResource.loadBalancerDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Defines the SAP Message Server properties.
     */
    public val messageServerProperties: Output<MessageServerPropertiesResponse>?
        get() = javaResource.messageServerProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> messageServerPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines the SAP Instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The central services instance subnet.
     */
    public val subnet: Output<String>
        get() = javaResource.subnet().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of virtual machines corresponding to the Central Services instance.
     */
    public val vmDetails: Output<List<CentralServerVmDetailsResponse>>
        get() = javaResource.vmDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    centralServerVmDetailsResponseToKotlin(args0)
                })
            })
        })
}

public object SAPCentralInstanceMapper : ResourceMapper<SAPCentralInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.SAPCentralInstance::class == javaResource::class

    override fun map(javaResource: Resource): SAPCentralInstance = SAPCentralInstance(
        javaResource as
            com.pulumi.azurenative.workloads.SAPCentralInstance,
    )
}

/**
 * @see [SAPCentralInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SAPCentralInstance].
 */
public suspend fun sapCentralInstance(
    name: String,
    block: suspend SAPCentralInstanceResourceBuilder.() -> Unit,
): SAPCentralInstance {
    val builder = SAPCentralInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SAPCentralInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapCentralInstance(name: String): SAPCentralInstance {
    val builder = SAPCentralInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
