@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse.Companion.toKotlin as managedRGConfigurationResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin as sAPVirtualInstanceErrorResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse.Companion.toKotlin as userAssignedServiceIdentityResponseToKotlin

/**
 * Builder for [SAPVirtualInstance].
 */
@PulumiTagMarker
public class SAPVirtualInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SAPVirtualInstanceArgs = SAPVirtualInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SAPVirtualInstanceArgsBuilder.() -> Unit) {
        val builder = SAPVirtualInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SAPVirtualInstance {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.SAPVirtualInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SAPVirtualInstance(builtJavaResource)
    }
}

/**
 * Define the Virtual Instance for SAP solutions resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create Infrastructure (with OS configuration) with custom resource names for Distributed System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 CustomResourceNames = new AzureNative.Workloads.Inputs.ThreeTierFullResourceNamesArgs
 *                 {
 *                     ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerFullResourceNamesArgs
 *                     {
 *                         AvailabilitySetName = "appAvSet",
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app0disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName0",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic0",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app0osdisk",
 *                                 VmName = "appvm0",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app1disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName1",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic1",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app1osdisk",
 *                                 VmName = "appvm1",
 *                             },
 *                         },
 *                     },
 *                     CentralServer = new AzureNative.Workloads.Inputs.CentralServerFullResourceNamesArgs
 *                     {
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "ascsdisk0",
 *                                     } },
 *                                 },
 *                                 HostName = "ascshostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ascsnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ascsosdisk",
 *                                 VmName = "ascsvm",
 *                             },
 *                         },
 *                     },
 *                     DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseServerFullResourceNamesArgs
 *                     {
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadata0",
 *                                         "hanadata1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalog0",
 *                                         "hanalog1",
 *                                         "hanalog2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanashared0",
 *                                         "hanashared1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsap0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbosdisk",
 *                                 VmName = "dbvm",
 *                             },
 *                         },
 *                     },
 *                     NamingPatternType = "FullResourceName",
 *                     SharedStorage = new AzureNative.Workloads.Inputs.SharedStorageResourceNamesArgs
 *                     {
 *                         SharedStorageAccountName = "storageacc",
 *                         SharedStorageAccountPrivateEndPointName = "peForxNFS",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					CustomResourceNames: workloads.ThreeTierFullResourceNames{
 * 						ApplicationServer: workloads.ApplicationServerFullResourceNames{
 * 							AvailabilitySetName: "appAvSet",
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app0disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName0",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic0",
 * 										},
 * 									},
 * 									OsDiskName: "app0osdisk",
 * 									VmName:     "appvm0",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app1disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName1",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic1",
 * 										},
 * 									},
 * 									OsDiskName: "app1osdisk",
 * 									VmName:     "appvm1",
 * 								},
 * 							},
 * 						},
 * 						CentralServer: workloads.CentralServerFullResourceNames{
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"ascsdisk0",
 * 										},
 * 									},
 * 									HostName: "ascshostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ascsnic",
 * 										},
 * 									},
 * 									OsDiskName: "ascsosdisk",
 * 									VmName:     "ascsvm",
 * 								},
 * 							},
 * 						},
 * 						DatabaseServer: workloads.DatabaseServerFullResourceNames{
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadata0",
 * 											"hanadata1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalog0",
 * 											"hanalog1",
 * 											"hanalog2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanashared0",
 * 											"hanashared1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsap0",
 * 										},
 * 									},
 * 									HostName: "dbhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbosdisk",
 * 									VmName:     "dbvm",
 * 								},
 * 							},
 * 						},
 * 						NamingPatternType: "FullResourceName",
 * 						SharedStorage: workloads.SharedStorageResourceNames{
 * 							SharedStorageAccountName:                "storageacc",
 * 							SharedStorageAccountPrivateEndPointName: "peForxNFS",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .customResourceNames(ThreeTierFullResourceNamesArgs.builder()
 *                         .applicationServer(ApplicationServerFullResourceNamesArgs.builder()
 *                             .availabilitySetName("appAvSet")
 *                             .virtualMachines(
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.of("default", "app0disk0"))
 *                                     .hostName("apphostName0")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("appnic0")
 *                                         .build())
 *                                     .osDiskName("app0osdisk")
 *                                     .vmName("appvm0")
 *                                     .build(),
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.of("default", "app1disk0"))
 *                                     .hostName("apphostName1")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("appnic1")
 *                                         .build())
 *                                     .osDiskName("app1osdisk")
 *                                     .vmName("appvm1")
 *                                     .build())
 *                             .build())
 *                         .centralServer(CentralServerFullResourceNamesArgs.builder()
 *                             .virtualMachines(VirtualMachineResourceNamesArgs.builder()
 *                                 .dataDiskNames(Map.of("default", "ascsdisk0"))
 *                                 .hostName("ascshostName")
 *                                 .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                     .networkInterfaceName("ascsnic")
 *                                     .build())
 *                                 .osDiskName("ascsosdisk")
 *                                 .vmName("ascsvm")
 *                                 .build())
 *                             .build())
 *                         .databaseServer(DatabaseServerFullResourceNamesArgs.builder()
 *                             .virtualMachines(VirtualMachineResourceNamesArgs.builder()
 *                                 .dataDiskNames(Map.ofEntries(
 *                                     Map.entry("hanaData",
 *                                         "hanadata0",
 *                                         "hanadata1"),
 *                                     Map.entry("hanaLog",
 *                                         "hanalog0",
 *                                         "hanalog1",
 *                                         "hanalog2"),
 *                                     Map.entry("hanaShared",
 *                                         "hanashared0",
 *                                         "hanashared1"),
 *                                     Map.entry("usrSap", "usrsap0")
 *                                 ))
 *                                 .hostName("dbhostName")
 *                                 .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                     .networkInterfaceName("dbnic")
 *                                     .build())
 *                                 .osDiskName("dbosdisk")
 *                                 .vmName("dbvm")
 *                                 .build())
 *                             .build())
 *                         .namingPatternType("FullResourceName")
 *                         .sharedStorage(SharedStorageResourceNamesArgs.builder()
 *                             .sharedStorageAccountName("storageacc")
 *                             .sharedStorageAccountPrivateEndPointName("peForxNFS")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure (with OS configuration) with custom resource names for HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 CustomResourceNames = new AzureNative.Workloads.Inputs.ThreeTierFullResourceNamesArgs
 *                 {
 *                     ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerFullResourceNamesArgs
 *                     {
 *                         AvailabilitySetName = "appAvSet",
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app0disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName0",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic0",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app0osdisk",
 *                                 VmName = "appvm0",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app1disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName1",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic1",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app1osdisk",
 *                                 VmName = "appvm1",
 *                             },
 *                         },
 *                     },
 *                     CentralServer = new AzureNative.Workloads.Inputs.CentralServerFullResourceNamesArgs
 *                     {
 *                         AvailabilitySetName = "csAvSet",
 *                         LoadBalancer = new AzureNative.Workloads.Inputs.LoadBalancerResourceNamesArgs
 *                         {
 *                             BackendPoolNames = new[]
 *                             {
 *                                 "ascsBackendPool",
 *                             },
 *                             FrontendIpConfigurationNames = new[]
 *                             {
 *                                 "ascsip0",
 *                                 "ersip0",
 *                             },
 *                             HealthProbeNames = new[]
 *                             {
 *                                 "ascsHealthProbe",
 *                                 "ersHealthProbe",
 *                             },
 *                             LoadBalancerName = "ascslb",
 *                         },
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 HostName = "ascshostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ascsnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ascsosdisk",
 *                                 VmName = "ascsvm",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 HostName = "ershostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ersnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ersosdisk",
 *                                 VmName = "ersvm",
 *                             },
 *                         },
 *                     },
 *                     DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseServerFullResourceNamesArgs
 *                     {
 *                         AvailabilitySetName = "dbAvSet",
 *                         LoadBalancer = new AzureNative.Workloads.Inputs.LoadBalancerResourceNamesArgs
 *                         {
 *                             BackendPoolNames = new[]
 *                             {
 *                                 "dbBackendPool",
 *                             },
 *                             FrontendIpConfigurationNames = new[]
 *                             {
 *                                 "dbip",
 *                             },
 *                             HealthProbeNames = new[]
 *                             {
 *                                 "dbHealthProbe",
 *                             },
 *                             LoadBalancerName = "dblb",
 *                         },
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadatapr0",
 *                                         "hanadatapr1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalogpr0",
 *                                         "hanalogpr1",
 *                                         "hanalogpr2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanasharedpr0",
 *                                         "hanasharedpr1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsappr0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbprhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbprnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbprosdisk",
 *                                 VmName = "dbvmpr",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadatasr0",
 *                                         "hanadatasr1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalogsr0",
 *                                         "hanalogsr1",
 *                                         "hanalogsr2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanasharedsr0",
 *                                         "hanasharedsr1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsapsr0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbsrhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbsrnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbsrosdisk",
 *                                 VmName = "dbvmsr",
 *                             },
 *                         },
 *                     },
 *                     NamingPatternType = "FullResourceName",
 *                     SharedStorage = new AzureNative.Workloads.Inputs.SharedStorageResourceNamesArgs
 *                     {
 *                         SharedStorageAccountName = "storageacc",
 *                         SharedStorageAccountPrivateEndPointName = "peForxNFS",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilitySet,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					CustomResourceNames: workloads.ThreeTierFullResourceNames{
 * 						ApplicationServer: workloads.ApplicationServerFullResourceNames{
 * 							AvailabilitySetName: "appAvSet",
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app0disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName0",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic0",
 * 										},
 * 									},
 * 									OsDiskName: "app0osdisk",
 * 									VmName:     "appvm0",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app1disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName1",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic1",
 * 										},
 * 									},
 * 									OsDiskName: "app1osdisk",
 * 									VmName:     "appvm1",
 * 								},
 * 							},
 * 						},
 * 						CentralServer: workloads.CentralServerFullResourceNames{
 * 							AvailabilitySetName: "csAvSet",
 * 							LoadBalancer: workloads.LoadBalancerResourceNames{
 * 								BackendPoolNames: []string{
 * 									"ascsBackendPool",
 * 								},
 * 								FrontendIpConfigurationNames: []string{
 * 									"ascsip0",
 * 									"ersip0",
 * 								},
 * 								HealthProbeNames: []string{
 * 									"ascsHealthProbe",
 * 									"ersHealthProbe",
 * 								},
 * 								LoadBalancerName: "ascslb",
 * 							},
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									HostName: "ascshostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ascsnic",
 * 										},
 * 									},
 * 									OsDiskName: "ascsosdisk",
 * 									VmName:     "ascsvm",
 * 								},
 * 								{
 * 									HostName: "ershostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ersnic",
 * 										},
 * 									},
 * 									OsDiskName: "ersosdisk",
 * 									VmName:     "ersvm",
 * 								},
 * 							},
 * 						},
 * 						DatabaseServer: workloads.DatabaseServerFullResourceNames{
 * 							AvailabilitySetName: "dbAvSet",
 * 							LoadBalancer: workloads.LoadBalancerResourceNames{
 * 								BackendPoolNames: []string{
 * 									"dbBackendPool",
 * 								},
 * 								FrontendIpConfigurationNames: []string{
 * 									"dbip",
 * 								},
 * 								HealthProbeNames: []string{
 * 									"dbHealthProbe",
 * 								},
 * 								LoadBalancerName: "dblb",
 * 							},
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadatapr0",
 * 											"hanadatapr1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalogpr0",
 * 											"hanalogpr1",
 * 											"hanalogpr2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanasharedpr0",
 * 											"hanasharedpr1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsappr0",
 * 										},
 * 									},
 * 									HostName: "dbprhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbprnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbprosdisk",
 * 									VmName:     "dbvmpr",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadatasr0",
 * 											"hanadatasr1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalogsr0",
 * 											"hanalogsr1",
 * 											"hanalogsr2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanasharedsr0",
 * 											"hanasharedsr1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsapsr0",
 * 										},
 * 									},
 * 									HostName: "dbsrhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbsrnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbsrosdisk",
 * 									VmName:     "dbvmsr",
 * 								},
 * 							},
 * 						},
 * 						NamingPatternType: "FullResourceName",
 * 						SharedStorage: workloads.SharedStorageResourceNames{
 * 							SharedStorageAccountName:                "storageacc",
 * 							SharedStorageAccountPrivateEndPointName: "peForxNFS",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilitySet,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .customResourceNames(ThreeTierFullResourceNamesArgs.builder()
 *                         .applicationServer(ApplicationServerFullResourceNamesArgs.builder()
 *                             .availabilitySetName("appAvSet")
 *                             .virtualMachines(
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.of("default", "app0disk0"))
 *                                     .hostName("apphostName0")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("appnic0")
 *                                         .build())
 *                                     .osDiskName("app0osdisk")
 *                                     .vmName("appvm0")
 *                                     .build(),
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.of("default", "app1disk0"))
 *                                     .hostName("apphostName1")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("appnic1")
 *                                         .build())
 *                                     .osDiskName("app1osdisk")
 *                                     .vmName("appvm1")
 *                                     .build())
 *                             .build())
 *                         .centralServer(CentralServerFullResourceNamesArgs.builder()
 *                             .availabilitySetName("csAvSet")
 *                             .loadBalancer(LoadBalancerResourceNamesArgs.builder()
 *                                 .backendPoolNames("ascsBackendPool")
 *                                 .frontendIpConfigurationNames(
 *                                     "ascsip0",
 *                                     "ersip0")
 *                                 .healthProbeNames(
 *                                     "ascsHealthProbe",
 *                                     "ersHealthProbe")
 *                                 .loadBalancerName("ascslb")
 *                                 .build())
 *                             .virtualMachines(
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .hostName("ascshostName")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("ascsnic")
 *                                         .build())
 *                                     .osDiskName("ascsosdisk")
 *                                     .vmName("ascsvm")
 *                                     .build(),
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .hostName("ershostName")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("ersnic")
 *                                         .build())
 *                                     .osDiskName("ersosdisk")
 *                                     .vmName("ersvm")
 *                                     .build())
 *                             .build())
 *                         .databaseServer(DatabaseServerFullResourceNamesArgs.builder()
 *                             .availabilitySetName("dbAvSet")
 *                             .loadBalancer(LoadBalancerResourceNamesArgs.builder()
 *                                 .backendPoolNames("dbBackendPool")
 *                                 .frontendIpConfigurationNames("dbip")
 *                                 .healthProbeNames("dbHealthProbe")
 *                                 .loadBalancerName("dblb")
 *                                 .build())
 *                             .virtualMachines(
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.ofEntries(
 *                                         Map.entry("hanaData",
 *                                             "hanadatapr0",
 *                                             "hanadatapr1"),
 *                                         Map.entry("hanaLog",
 *                                             "hanalogpr0",
 *                                             "hanalogpr1",
 *                                             "hanalogpr2"),
 *                                         Map.entry("hanaShared",
 *                                             "hanasharedpr0",
 *                                             "hanasharedpr1"),
 *                                         Map.entry("usrSap", "usrsappr0")
 *                                     ))
 *                                     .hostName("dbprhostName")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("dbprnic")
 *                                         .build())
 *                                     .osDiskName("dbprosdisk")
 *                                     .vmName("dbvmpr")
 *                                     .build(),
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.ofEntries(
 *                                         Map.entry("hanaData",
 *                                             "hanadatasr0",
 *                                             "hanadatasr1"),
 *                                         Map.entry("hanaLog",
 *                                             "hanalogsr0",
 *                                             "hanalogsr1",
 *                                             "hanalogsr2"),
 *                                         Map.entry("hanaShared",
 *                                             "hanasharedsr0",
 *                                             "hanasharedsr1"),
 *                                         Map.entry("usrSap", "usrsapsr0")
 *                                     ))
 *                                     .hostName("dbsrhostName")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("dbsrnic")
 *                                         .build())
 *                                     .osDiskName("dbsrosdisk")
 *                                     .vmName("dbvmsr")
 *                                     .build())
 *                             .build())
 *                         .namingPatternType("FullResourceName")
 *                         .sharedStorage(SharedStorageResourceNamesArgs.builder()
 *                             .sharedStorageAccountName("storageacc")
 *                             .sharedStorageAccountPrivateEndPointName("peForxNFS")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilitySet")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure (with OS configuration) with custom resource names for HA system with Availability Zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 CustomResourceNames = new AzureNative.Workloads.Inputs.ThreeTierFullResourceNamesArgs
 *                 {
 *                     ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerFullResourceNamesArgs
 *                     {
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app0disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName0",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic0",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app0osdisk",
 *                                 VmName = "appvm0",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app1disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName1",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic1",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app1osdisk",
 *                                 VmName = "appvm1",
 *                             },
 *                         },
 *                     },
 *                     CentralServer = new AzureNative.Workloads.Inputs.CentralServerFullResourceNamesArgs
 *                     {
 *                         LoadBalancer = new AzureNative.Workloads.Inputs.LoadBalancerResourceNamesArgs
 *                         {
 *                             BackendPoolNames = new[]
 *                             {
 *                                 "ascsBackendPool",
 *                             },
 *                             FrontendIpConfigurationNames = new[]
 *                             {
 *                                 "ascsip0",
 *                                 "ersip0",
 *                             },
 *                             HealthProbeNames = new[]
 *                             {
 *                                 "ascsHealthProbe",
 *                                 "ersHealthProbe",
 *                             },
 *                             LoadBalancerName = "ascslb",
 *                         },
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 HostName = "ascshostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ascsnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ascsosdisk",
 *                                 VmName = "ascsvm",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 HostName = "ershostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ersnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ersosdisk",
 *                                 VmName = "ersvm",
 *                             },
 *                         },
 *                     },
 *                     DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseServerFullResourceNamesArgs
 *                     {
 *                         LoadBalancer = new AzureNative.Workloads.Inputs.LoadBalancerResourceNamesArgs
 *                         {
 *                             BackendPoolNames = new[]
 *                             {
 *                                 "dbBackendPool",
 *                             },
 *                             FrontendIpConfigurationNames = new[]
 *                             {
 *                                 "dbip",
 *                             },
 *                             HealthProbeNames = new[]
 *                             {
 *                                 "dbHealthProbe",
 *                             },
 *                             LoadBalancerName = "dblb",
 *                         },
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadatapr0",
 *                                         "hanadatapr1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalogpr0",
 *                                         "hanalogpr1",
 *                                         "hanalogpr2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanasharedpr0",
 *                                         "hanasharedpr1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsappr0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbprhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbprnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbprosdisk",
 *                                 VmName = "dbvmpr",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadatasr0",
 *                                         "hanadatasr1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalogsr0",
 *                                         "hanalogsr1",
 *                                         "hanalogsr2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanasharedsr0",
 *                                         "hanasharedsr1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsapsr0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbsrhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbsrnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbsrosdisk",
 *                                 VmName = "dbvmsr",
 *                             },
 *                         },
 *                     },
 *                     NamingPatternType = "FullResourceName",
 *                     SharedStorage = new AzureNative.Workloads.Inputs.SharedStorageResourceNamesArgs
 *                     {
 *                         SharedStorageAccountName = "storageacc",
 *                         SharedStorageAccountPrivateEndPointName = "peForxNFS",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilityZone,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					CustomResourceNames: workloads.ThreeTierFullResourceNames{
 * 						ApplicationServer: workloads.ApplicationServerFullResourceNames{
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app0disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName0",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic0",
 * 										},
 * 									},
 * 									OsDiskName: "app0osdisk",
 * 									VmName:     "appvm0",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app1disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName1",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic1",
 * 										},
 * 									},
 * 									OsDiskName: "app1osdisk",
 * 									VmName:     "appvm1",
 * 								},
 * 							},
 * 						},
 * 						CentralServer: workloads.CentralServerFullResourceNames{
 * 							LoadBalancer: workloads.LoadBalancerResourceNames{
 * 								BackendPoolNames: []string{
 * 									"ascsBackendPool",
 * 								},
 * 								FrontendIpConfigurationNames: []string{
 * 									"ascsip0",
 * 									"ersip0",
 * 								},
 * 								HealthProbeNames: []string{
 * 									"ascsHealthProbe",
 * 									"ersHealthProbe",
 * 								},
 * 								LoadBalancerName: "ascslb",
 * 							},
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									HostName: "ascshostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ascsnic",
 * 										},
 * 									},
 * 									OsDiskName: "ascsosdisk",
 * 									VmName:     "ascsvm",
 * 								},
 * 								{
 * 									HostName: "ershostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ersnic",
 * 										},
 * 									},
 * 									OsDiskName: "ersosdisk",
 * 									VmName:     "ersvm",
 * 								},
 * 							},
 * 						},
 * 						DatabaseServer: workloads.DatabaseServerFullResourceNames{
 * 							LoadBalancer: workloads.LoadBalancerResourceNames{
 * 								BackendPoolNames: []string{
 * 									"dbBackendPool",
 * 								},
 * 								FrontendIpConfigurationNames: []string{
 * 									"dbip",
 * 								},
 * 								HealthProbeNames: []string{
 * 									"dbHealthProbe",
 * 								},
 * 								LoadBalancerName: "dblb",
 * 							},
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadatapr0",
 * 											"hanadatapr1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalogpr0",
 * 											"hanalogpr1",
 * 											"hanalogpr2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanasharedpr0",
 * 											"hanasharedpr1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsappr0",
 * 										},
 * 									},
 * 									HostName: "dbprhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbprnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbprosdisk",
 * 									VmName:     "dbvmpr",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadatasr0",
 * 											"hanadatasr1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalogsr0",
 * 											"hanalogsr1",
 * 											"hanalogsr2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanasharedsr0",
 * 											"hanasharedsr1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsapsr0",
 * 										},
 * 									},
 * 									HostName: "dbsrhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbsrnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbsrosdisk",
 * 									VmName:     "dbvmsr",
 * 								},
 * 							},
 * 						},
 * 						NamingPatternType: "FullResourceName",
 * 						SharedStorage: workloads.SharedStorageResourceNames{
 * 							SharedStorageAccountName:                "storageacc",
 * 							SharedStorageAccountPrivateEndPointName: "peForxNFS",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilityZone,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .customResourceNames(ThreeTierFullResourceNamesArgs.builder()
 *                         .applicationServer(ApplicationServerFullResourceNamesArgs.builder()
 *                             .virtualMachines(
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.of("default", "app0disk0"))
 *                                     .hostName("apphostName0")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("appnic0")
 *                                         .build())
 *                                     .osDiskName("app0osdisk")
 *                                     .vmName("appvm0")
 *                                     .build(),
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.of("default", "app1disk0"))
 *                                     .hostName("apphostName1")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("appnic1")
 *                                         .build())
 *                                     .osDiskName("app1osdisk")
 *                                     .vmName("appvm1")
 *                                     .build())
 *                             .build())
 *                         .centralServer(CentralServerFullResourceNamesArgs.builder()
 *                             .loadBalancer(LoadBalancerResourceNamesArgs.builder()
 *                                 .backendPoolNames("ascsBackendPool")
 *                                 .frontendIpConfigurationNames(
 *                                     "ascsip0",
 *                                     "ersip0")
 *                                 .healthProbeNames(
 *                                     "ascsHealthProbe",
 *                                     "ersHealthProbe")
 *                                 .loadBalancerName("ascslb")
 *                                 .build())
 *                             .virtualMachines(
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .hostName("ascshostName")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("ascsnic")
 *                                         .build())
 *                                     .osDiskName("ascsosdisk")
 *                                     .vmName("ascsvm")
 *                                     .build(),
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .hostName("ershostName")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("ersnic")
 *                                         .build())
 *                                     .osDiskName("ersosdisk")
 *                                     .vmName("ersvm")
 *                                     .build())
 *                             .build())
 *                         .databaseServer(DatabaseServerFullResourceNamesArgs.builder()
 *                             .loadBalancer(LoadBalancerResourceNamesArgs.builder()
 *                                 .backendPoolNames("dbBackendPool")
 *                                 .frontendIpConfigurationNames("dbip")
 *                                 .healthProbeNames("dbHealthProbe")
 *                                 .loadBalancerName("dblb")
 *                                 .build())
 *                             .virtualMachines(
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.ofEntries(
 *                                         Map.entry("hanaData",
 *                                             "hanadatapr0",
 *                                             "hanadatapr1"),
 *                                         Map.entry("hanaLog",
 *                                             "hanalogpr0",
 *                                             "hanalogpr1",
 *                                             "hanalogpr2"),
 *                                         Map.entry("hanaShared",
 *                                             "hanasharedpr0",
 *                                             "hanasharedpr1"),
 *                                         Map.entry("usrSap", "usrsappr0")
 *                                     ))
 *                                     .hostName("dbprhostName")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("dbprnic")
 *                                         .build())
 *                                     .osDiskName("dbprosdisk")
 *                                     .vmName("dbvmpr")
 *                                     .build(),
 *                                 VirtualMachineResourceNamesArgs.builder()
 *                                     .dataDiskNames(Map.ofEntries(
 *                                         Map.entry("hanaData",
 *                                             "hanadatasr0",
 *                                             "hanadatasr1"),
 *                                         Map.entry("hanaLog",
 *                                             "hanalogsr0",
 *                                             "hanalogsr1",
 *                                             "hanalogsr2"),
 *                                         Map.entry("hanaShared",
 *                                             "hanasharedsr0",
 *                                             "hanasharedsr1"),
 *                                         Map.entry("usrSap", "usrsapsr0")
 *                                     ))
 *                                     .hostName("dbsrhostName")
 *                                     .networkInterfaces(NetworkInterfaceResourceNamesArgs.builder()
 *                                         .networkInterfaceName("dbsrnic")
 *                                         .build())
 *                                     .osDiskName("dbsrosdisk")
 *                                     .vmName("dbvmsr")
 *                                     .build())
 *                             .build())
 *                         .namingPatternType("FullResourceName")
 *                         .sharedStorage(SharedStorageResourceNamesArgs.builder()
 *                             .sharedStorageAccountName("storageacc")
 *                             .sharedStorageAccountPrivateEndPointName("peForxNFS")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilityZone")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure (with OS configuration) with custom resource names for Single Server System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "xyz",
 *                                 PublicKey = "abc",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.NonProd,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					DatabaseType:     workloads.SAPDatabaseTypeHANA,
 * 					DeploymentType:   "SingleServer",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 					SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "RHEL-SAP",
 * 							Publisher: "RedHat",
 * 							Sku:       "84sapha-gen2",
 * 							Version:   "latest",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "{your-username}",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								SshKeyPair: workloads.SshKeyPair{
 * 									PrivateKey: "xyz",
 * 									PublicKey:  "abc",
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeNonProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(SingleServerConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .databaseType("HANA")
 *                     .deploymentType("SingleServer")
 *                     .networkConfiguration(NetworkConfigurationArgs.builder()
 *                         .isSecondaryIpEnabled(true)
 *                         .build())
 *                     .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                     .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                         .imageReference(ImageReferenceArgs.builder()
 *                             .offer("RHEL-SAP")
 *                             .publisher("RedHat")
 *                             .sku("84sapha-gen2")
 *                             .version("latest")
 *                             .build())
 *                         .osProfile(OSProfileArgs.builder()
 *                             .adminUsername("{your-username}")
 *                             .osConfiguration(LinuxConfigurationArgs.builder()
 *                                 .disablePasswordAuthentication(true)
 *                                 .osType("Linux")
 *                                 .sshKeyPair(SshKeyPairArgs.builder()
 *                                     .privateKey("xyz")
 *                                     .publicKey("abc")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .vmSize("Standard_E32ds_v4")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure only for Distributed System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "Deployment",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "Deployment",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("Deployment")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure only for HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "Deployment",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 5,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilitySet,
 *                 },
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "Deployment",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 5,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilitySet,
 * 					},
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("Deployment")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(5)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilitySet")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure only for HA System with Availability Zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "Deployment",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilityZone,
 *                 },
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "Deployment",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilityZone,
 * 					},
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("Deployment")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .ssh(SshConfigurationArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .keyData("ssh-rsa public key")
 *                                             .build())
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilityZone")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure only for Single Server System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "Deployment",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                             {
 *                                 PublicKeys = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                     {
 *                                         KeyData = "ssh-rsa public key",
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.NonProd,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "Deployment",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					DatabaseType:     workloads.SAPDatabaseTypeHANA,
 * 					DeploymentType:   "SingleServer",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 					SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "RHEL-SAP",
 * 							Publisher: "RedHat",
 * 							Sku:       "84sapha-gen2",
 * 							Version:   "latest",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "{your-username}",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								Ssh: workloads.SshConfiguration{
 * 									PublicKeys: []workloads.SshPublicKey{
 * 										{
 * 											KeyData: "ssh-rsa public key",
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeNonProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("Deployment")
 *                 .infrastructureConfiguration(SingleServerConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .databaseType("HANA")
 *                     .deploymentType("SingleServer")
 *                     .networkConfiguration(NetworkConfigurationArgs.builder()
 *                         .isSecondaryIpEnabled(true)
 *                         .build())
 *                     .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                     .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                         .imageReference(ImageReferenceArgs.builder()
 *                             .offer("RHEL-SAP")
 *                             .publisher("RedHat")
 *                             .sku("84sapha-gen2")
 *                             .version("latest")
 *                             .build())
 *                         .osProfile(OSProfileArgs.builder()
 *                             .adminUsername("{your-username}")
 *                             .osConfiguration(LinuxConfigurationArgs.builder()
 *                                 .disablePasswordAuthentication(true)
 *                                 .osType("Linux")
 *                                 .ssh(SshConfigurationArgs.builder()
 *                                     .publicKeys(SshPublicKeyArgs.builder()
 *                                         .keyData("ssh-rsa public key")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .vmSize("Standard_E32ds_v4")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with Disk and OS configuration for Distributed System (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     DiskConfiguration = new AzureNative.Workloads.Inputs.DiskConfigurationArgs
 *                     {
 *                         DiskVolumeConfigurations =
 *                         {
 *                             { "backup", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 2,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "hana/data", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 4,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                             { "hana/log", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 3,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                             { "hana/shared", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "os", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 64,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "usr/sap", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                         },
 *                     },
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * Configuration: workloads.DeploymentWithOSConfiguration{
 * AppLocation: "eastus",
 * ConfigurationType: "DeploymentWithOSConfig",
 * InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * AppResourceGroup: "X00-RG",
 * ApplicationServer: workloads.ApplicationServerConfiguration{
 * InstanceCount: 6,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E32ds_v4",
 * },
 * },
 * CentralServer: workloads.CentralServerConfiguration{
 * InstanceCount: 1,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E16ds_v4",
 * },
 * },
 * DatabaseServer: workloads.DatabaseConfiguration{
 * DatabaseType: workloads.SAPDatabaseTypeHANA,
 * DiskConfiguration: workloads.DiskConfiguration{
 * DiskVolumeConfigurations: interface{}{
 * Backup: workloads.DiskVolumeConfiguration{
 * Count: 2,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Hana/data: workloads.DiskVolumeConfiguration{
 * Count: 4,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * Hana/log: workloads.DiskVolumeConfiguration{
 * Count: 3,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * Hana/shared: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Os: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 64,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Usr/sap: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * },
 * },
 * InstanceCount: 1,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_M32ts",
 * },
 * },
 * DeploymentType: "ThreeTier",
 * },
 * OsSapConfiguration: workloads.OsSapConfiguration{
 * SapFqdn: "xyz.test.com",
 * },
 * },
 * Environment: pulumi.String(workloads.SAPEnvironmentTypeProd),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * SapProduct: pulumi.String(workloads.SAPProductTypeS4HANA),
 * SapVirtualInstanceName: pulumi.String("X00"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .diskConfiguration(DiskConfigurationArgs.builder()
 *                             .diskVolumeConfigurations(Map.ofEntries(
 *                                 Map.entry("backup", Map.ofEntries(
 *                                     Map.entry("count", 2),
 *                                     Map.entry("sizeGB", 256),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("hana/data", Map.ofEntries(
 *                                     Map.entry("count", 4),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 )),
 *                                 Map.entry("hana/log", Map.ofEntries(
 *                                     Map.entry("count", 3),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 )),
 *                                 Map.entry("hana/shared", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 256),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("os", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 64),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("usr/sap", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 ))
 *                             ))
 *                             .build())
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with Disk and OS configuration for HA System with Availability Set (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     DiskConfiguration = new AzureNative.Workloads.Inputs.DiskConfigurationArgs
 *                     {
 *                         DiskVolumeConfigurations =
 *                         {
 *                             { "backup", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 2,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "hana/data", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 4,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                             { "hana/log", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 3,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                             { "hana/shared", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "os", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 64,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "usr/sap", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                         },
 *                     },
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilitySet,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * Configuration: workloads.DeploymentWithOSConfiguration{
 * AppLocation: "eastus",
 * ConfigurationType: "DeploymentWithOSConfig",
 * InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * AppResourceGroup: "X00-RG",
 * ApplicationServer: workloads.ApplicationServerConfiguration{
 * InstanceCount: 6,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E32ds_v4",
 * },
 * },
 * CentralServer: workloads.CentralServerConfiguration{
 * InstanceCount: 2,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E16ds_v4",
 * },
 * },
 * DatabaseServer: workloads.DatabaseConfiguration{
 * DatabaseType: workloads.SAPDatabaseTypeHANA,
 * DiskConfiguration: workloads.DiskConfiguration{
 * DiskVolumeConfigurations: interface{}{
 * Backup: workloads.DiskVolumeConfiguration{
 * Count: 2,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Hana/data: workloads.DiskVolumeConfiguration{
 * Count: 4,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * Hana/log: workloads.DiskVolumeConfiguration{
 * Count: 3,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * Hana/shared: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Os: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 64,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Usr/sap: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * },
 * },
 * InstanceCount: 2,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_M32ts",
 * },
 * },
 * DeploymentType: "ThreeTier",
 * HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilitySet,
 * },
 * },
 * OsSapConfiguration: workloads.OsSapConfiguration{
 * SapFqdn: "xyz.test.com",
 * },
 * },
 * Environment: pulumi.String(workloads.SAPEnvironmentTypeProd),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * SapProduct: pulumi.String(workloads.SAPProductTypeS4HANA),
 * SapVirtualInstanceName: pulumi.String("X00"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .diskConfiguration(DiskConfigurationArgs.builder()
 *                             .diskVolumeConfigurations(Map.ofEntries(
 *                                 Map.entry("backup", Map.ofEntries(
 *                                     Map.entry("count", 2),
 *                                     Map.entry("sizeGB", 256),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("hana/data", Map.ofEntries(
 *                                     Map.entry("count", 4),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 )),
 *                                 Map.entry("hana/log", Map.ofEntries(
 *                                     Map.entry("count", 3),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 )),
 *                                 Map.entry("hana/shared", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 256),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("os", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 64),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("usr/sap", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 ))
 *                             ))
 *                             .build())
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilitySet")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with Disk and OS configuration for HA System with Availability Zone (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     DiskConfiguration = new AzureNative.Workloads.Inputs.DiskConfigurationArgs
 *                     {
 *                         DiskVolumeConfigurations =
 *                         {
 *                             { "backup", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 2,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "hana/data", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 4,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                             { "hana/log", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 3,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                             { "hana/shared", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "os", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 64,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                                 },
 *                             } },
 *                             { "usr/sap", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                                 },
 *                             } },
 *                         },
 *                     },
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilityZone,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * Configuration: workloads.DeploymentWithOSConfiguration{
 * AppLocation: "eastus",
 * ConfigurationType: "DeploymentWithOSConfig",
 * InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * AppResourceGroup: "X00-RG",
 * ApplicationServer: workloads.ApplicationServerConfiguration{
 * InstanceCount: 6,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E32ds_v4",
 * },
 * },
 * CentralServer: workloads.CentralServerConfiguration{
 * InstanceCount: 2,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E16ds_v4",
 * },
 * },
 * DatabaseServer: workloads.DatabaseConfiguration{
 * DatabaseType: workloads.SAPDatabaseTypeHANA,
 * DiskConfiguration: workloads.DiskConfiguration{
 * DiskVolumeConfigurations: interface{}{
 * Backup: workloads.DiskVolumeConfiguration{
 * Count: 2,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Hana/data: workloads.DiskVolumeConfiguration{
 * Count: 4,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * Hana/log: workloads.DiskVolumeConfiguration{
 * Count: 3,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * Hana/shared: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Os: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 64,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Usr/sap: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * },
 * },
 * InstanceCount: 2,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_M32ts",
 * },
 * },
 * DeploymentType: "ThreeTier",
 * HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilityZone,
 * },
 * },
 * OsSapConfiguration: workloads.OsSapConfiguration{
 * SapFqdn: "xyz.test.com",
 * },
 * },
 * Environment: pulumi.String(workloads.SAPEnvironmentTypeProd),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * SapProduct: pulumi.String(workloads.SAPProductTypeS4HANA),
 * SapVirtualInstanceName: pulumi.String("X00"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .diskConfiguration(DiskConfigurationArgs.builder()
 *                             .diskVolumeConfigurations(Map.ofEntries(
 *                                 Map.entry("backup", Map.ofEntries(
 *                                     Map.entry("count", 2),
 *                                     Map.entry("sizeGB", 256),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("hana/data", Map.ofEntries(
 *                                     Map.entry("count", 4),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 )),
 *                                 Map.entry("hana/log", Map.ofEntries(
 *                                     Map.entry("count", 3),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 )),
 *                                 Map.entry("hana/shared", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 256),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("os", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 64),
 *                                     Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                                 )),
 *                                 Map.entry("usr/sap", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("sizeGB", 128),
 *                                     Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                                 ))
 *                             ))
 *                             .build())
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilityZone")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with Disk and OS configurations for Single Server System (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                 DbDiskConfiguration = new AzureNative.Workloads.Inputs.DiskConfigurationArgs
 *                 {
 *                     DiskVolumeConfigurations =
 *                     {
 *                         { "backup", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 2,
 *                             SizeGB = 256,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                             },
 *                         } },
 *                         { "hana/data", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 4,
 *                             SizeGB = 128,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                             },
 *                         } },
 *                         { "hana/log", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 3,
 *                             SizeGB = 128,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                             },
 *                         } },
 *                         { "hana/shared", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 1,
 *                             SizeGB = 256,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                             },
 *                         } },
 *                         { "os", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 1,
 *                             SizeGB = 64,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = AzureNative.Workloads.DiskSkuName.StandardSSD_LRS,
 *                             },
 *                         } },
 *                         { "usr/sap", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 1,
 *                             SizeGB = 128,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = AzureNative.Workloads.DiskSkuName.Premium_LRS,
 *                             },
 *                         } },
 *                     },
 *                 },
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "xyz",
 *                                 PublicKey = "abc",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.NonProd,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * Configuration: workloads.DeploymentWithOSConfiguration{
 * AppLocation: "eastus",
 * ConfigurationType: "DeploymentWithOSConfig",
 * InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * AppResourceGroup: "X00-RG",
 * DatabaseType: workloads.SAPDatabaseTypeHANA,
 * DbDiskConfiguration: workloads.DiskConfiguration{
 * DiskVolumeConfigurations: interface{}{
 * Backup: workloads.DiskVolumeConfiguration{
 * Count: 2,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Hana/data: workloads.DiskVolumeConfiguration{
 * Count: 4,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * Hana/log: workloads.DiskVolumeConfiguration{
 * Count: 3,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * Hana/shared: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Os: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 64,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_StandardSSD_LRS,
 * },
 * },
 * Usr/sap: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: workloads.DiskSkuName_Premium_LRS,
 * },
 * },
 * },
 * },
 * DeploymentType: "SingleServer",
 * NetworkConfiguration: workloads.NetworkConfiguration{
 * IsSecondaryIpEnabled: true,
 * },
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E32ds_v4",
 * },
 * },
 * OsSapConfiguration: workloads.OsSapConfiguration{
 * SapFqdn: "xyz.test.com",
 * },
 * },
 * Environment: pulumi.String(workloads.SAPEnvironmentTypeNonProd),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * SapProduct: pulumi.String(workloads.SAPProductTypeS4HANA),
 * SapVirtualInstanceName: pulumi.String("X00"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(SingleServerConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .databaseType("HANA")
 *                     .dbDiskConfiguration(DiskConfigurationArgs.builder()
 *                         .diskVolumeConfigurations(Map.ofEntries(
 *                             Map.entry("backup", Map.ofEntries(
 *                                 Map.entry("count", 2),
 *                                 Map.entry("sizeGB", 256),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("hana/data", Map.ofEntries(
 *                                 Map.entry("count", 4),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             )),
 *                             Map.entry("hana/log", Map.ofEntries(
 *                                 Map.entry("count", 3),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             )),
 *                             Map.entry("hana/shared", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 256),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("os", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 64),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("usr/sap", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             ))
 *                         ))
 *                         .build())
 *                     .deploymentType("SingleServer")
 *                     .networkConfiguration(NetworkConfigurationArgs.builder()
 *                         .isSecondaryIpEnabled(true)
 *                         .build())
 *                     .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                     .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                         .imageReference(ImageReferenceArgs.builder()
 *                             .offer("RHEL-SAP")
 *                             .publisher("RedHat")
 *                             .sku("84sapha-gen2")
 *                             .version("latest")
 *                             .build())
 *                         .osProfile(OSProfileArgs.builder()
 *                             .adminUsername("{your-username}")
 *                             .osConfiguration(LinuxConfigurationArgs.builder()
 *                                 .disablePasswordAuthentication(true)
 *                                 .osType("Linux")
 *                                 .sshKeyPair(SshKeyPairArgs.builder()
 *                                     .privateKey("xyz")
 *                                     .publicKey("abc")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .vmSize("Standard_E32ds_v4")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with OS configuration for Distributed System (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with OS configuration for HA System with Availability Set (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilitySet,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilitySet,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilitySet")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with OS configuration for HA System with Availability Zone (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilityZone,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilityZone,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilityZone")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with OS configuration for Single Server System (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "xyz",
 *                                 PublicKey = "abc",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.NonProd,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					DatabaseType:     workloads.SAPDatabaseTypeHANA,
 * 					DeploymentType:   "SingleServer",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 					SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "RHEL-SAP",
 * 							Publisher: "RedHat",
 * 							Sku:       "84sapha-gen2",
 * 							Version:   "latest",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "{your-username}",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								SshKeyPair: workloads.SshKeyPair{
 * 									PrivateKey: "xyz",
 * 									PublicKey:  "abc",
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeNonProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(SingleServerConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .databaseType("HANA")
 *                     .deploymentType("SingleServer")
 *                     .networkConfiguration(NetworkConfigurationArgs.builder()
 *                         .isSecondaryIpEnabled(true)
 *                         .build())
 *                     .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                     .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                         .imageReference(ImageReferenceArgs.builder()
 *                             .offer("RHEL-SAP")
 *                             .publisher("RedHat")
 *                             .sku("84sapha-gen2")
 *                             .version("latest")
 *                             .build())
 *                         .osProfile(OSProfileArgs.builder()
 *                             .adminUsername("{your-username}")
 *                             .osConfiguration(LinuxConfigurationArgs.builder()
 *                                 .disablePasswordAuthentication(true)
 *                                 .osType("Linux")
 *                                 .sshKeyPair(SshKeyPairArgs.builder()
 *                                     .privateKey("xyz")
 *                                     .publicKey("abc")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .vmSize("Standard_E32ds_v4")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with a new SAP Transport Directory Fileshare
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 StorageConfiguration = new AzureNative.Workloads.Inputs.StorageConfigurationArgs
 *                 {
 *                     TransportFileShareConfiguration = new AzureNative.Workloads.Inputs.CreateAndMountFileShareConfigurationArgs
 *                     {
 *                         ConfigurationType = "CreateAndMount",
 *                         ResourceGroup = "rgName",
 *                         StorageAccountName = "storageName",
 *                     },
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					StorageConfiguration: workloads.StorageConfiguration{
 * 						TransportFileShareConfiguration: workloads.CreateAndMountFileShareConfiguration{
 * 							ConfigurationType:  "CreateAndMount",
 * 							ResourceGroup:      "rgName",
 * 							StorageAccountName: "storageName",
 * 						},
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .storageConfiguration(StorageConfigurationArgs.builder()
 *                         .transportFileShareConfiguration(CreateAndMountFileShareConfigurationArgs.builder()
 *                             .configurationType("CreateAndMount")
 *                             .resourceGroup("rgName")
 *                             .storageAccountName("storageName")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with an existing SAP Transport Directory Fileshare
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 StorageConfiguration = new AzureNative.Workloads.Inputs.StorageConfigurationArgs
 *                 {
 *                     TransportFileShareConfiguration = new AzureNative.Workloads.Inputs.MountFileShareConfigurationArgs
 *                     {
 *                         ConfigurationType = "Mount",
 *                         Id = "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint",
 *                         PrivateEndpointId = "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint",
 *                     },
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					StorageConfiguration: workloads.StorageConfiguration{
 * 						TransportFileShareConfiguration: workloads.MountFileShareConfiguration{
 * 							ConfigurationType: "Mount",
 * 							Id:                "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint",
 * 							PrivateEndpointId: "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint",
 * 						},
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .storageConfiguration(StorageConfigurationArgs.builder()
 *                         .transportFileShareConfiguration(CreateAndMountFileShareConfigurationArgs.builder()
 *                             .configurationType("Mount")
 *                             .id("/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint")
 *                             .privateEndpointId("/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure without a SAP Transport Directory Fileshare
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 StorageConfiguration = new AzureNative.Workloads.Inputs.StorageConfigurationArgs
 *                 {
 *                     TransportFileShareConfiguration = new AzureNative.Workloads.Inputs.SkipFileShareConfigurationArgs
 *                     {
 *                         ConfigurationType = "Skip",
 *                     },
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					StorageConfiguration: workloads.StorageConfiguration{
 * 						TransportFileShareConfiguration: workloads.SkipFileShareConfiguration{
 * 							ConfigurationType: "Skip",
 * 						},
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .storageConfiguration(StorageConfigurationArgs.builder()
 *                         .transportFileShareConfiguration(SkipFileShareConfigurationArgs.builder()
 *                             .configurationType("Skip")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Detect SAP Software Installation on a Distributed System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "{{resourcegrp}}",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E4ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E4ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "sap.bpaas.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.ExternalInstallationSoftwareConfigurationArgs
 *             {
 *                 CentralServerVmId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *                 SoftwareInstallationType = "External",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "eastus2",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags =
 *         {
 *             { "created by", "azureuser" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "{{resourcegrp}}",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E4ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E4ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "sap.bpaas.com",
 * 				},
 * 				SoftwareConfiguration: workloads.ExternalInstallationSoftwareConfiguration{
 * 					CentralServerVmId:        "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 					SoftwareInstallationType: "External",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("eastus2"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags: pulumi.StringMap{
 * 				"created by": pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("{{resourcegrp}}")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("azureuser")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("{{privateKey}}")
 *                                         .publicKey("{{sshkey}}")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E4ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("azureuser")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("{{privateKey}}")
 *                                         .publicKey("{{sshkey}}")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E4ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("azureuser")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("{{privateKey}}")
 *                                         .publicKey("{{sshkey}}")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .networkConfiguration(NetworkConfigurationArgs.builder()
 *                         .isSecondaryIpEnabled(true)
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("sap.bpaas.com")
 *                     .build())
 *                 .softwareConfiguration(ExternalInstallationSoftwareConfigurationArgs.builder()
 *                     .centralServerVmId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0")
 *                     .softwareInstallationType("External")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("eastus2")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags(Map.of("created by", "azureuser"))
 *             .build());
 *     }
 * }
 * ```
 * ### Detect SAP Software Installation on a Single Server System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP-HA",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "xyz",
 *                                 PublicKey = "abc",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.ExternalInstallationSoftwareConfigurationArgs
 *             {
 *                 CentralServerVmId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *                 SoftwareInstallationType = "External",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.NonProd,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					DatabaseType:     workloads.SAPDatabaseTypeHANA,
 * 					DeploymentType:   "SingleServer",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 					SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "RHEL-SAP-HA",
 * 							Publisher: "RedHat",
 * 							Sku:       "84sapha-gen2",
 * 							Version:   "latest",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "{your-username}",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								SshKeyPair: workloads.SshKeyPair{
 * 									PrivateKey: "xyz",
 * 									PublicKey:  "abc",
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 				SoftwareConfiguration: workloads.ExternalInstallationSoftwareConfiguration{
 * 					CentralServerVmId:        "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 					SoftwareInstallationType: "External",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeNonProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(SingleServerConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .databaseType("HANA")
 *                     .deploymentType("SingleServer")
 *                     .networkConfiguration(NetworkConfigurationArgs.builder()
 *                         .isSecondaryIpEnabled(true)
 *                         .build())
 *                     .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                     .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                         .imageReference(ImageReferenceArgs.builder()
 *                             .offer("RHEL-SAP-HA")
 *                             .publisher("RedHat")
 *                             .sku("84sapha-gen2")
 *                             .version("latest")
 *                             .build())
 *                         .osProfile(OSProfileArgs.builder()
 *                             .adminUsername("{your-username}")
 *                             .osConfiguration(LinuxConfigurationArgs.builder()
 *                                 .disablePasswordAuthentication(true)
 *                                 .osType("Linux")
 *                                 .sshKeyPair(SshKeyPairArgs.builder()
 *                                     .privateKey("xyz")
 *                                     .publicKey("abc")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .vmSize("Standard_E32ds_v4")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .softwareConfiguration(ExternalInstallationSoftwareConfigurationArgs.builder()
 *                     .centralServerVmId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0")
 *                     .softwareInstallationType("External")
 *                     .build())
 *                 .build())
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Detect SAP Software Installation on an HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilitySet,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.ExternalInstallationSoftwareConfigurationArgs
 *             {
 *                 CentralServerVmId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *                 SoftwareInstallationType = "External",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilitySet,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 				SoftwareConfiguration: workloads.ExternalInstallationSoftwareConfiguration{
 * 					CentralServerVmId:        "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 					SoftwareInstallationType: "External",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilitySet")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .softwareConfiguration(ExternalInstallationSoftwareConfigurationArgs.builder()
 *                     .centralServerVmId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0")
 *                     .softwareInstallationType("External")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Detect SAP Software Installation on an HA System with Availability Zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = AzureNative.Workloads.SAPDatabaseType.HANA,
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = AzureNative.Workloads.SAPHighAvailabilityType.AvailabilityZone,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.ExternalInstallationSoftwareConfigurationArgs
 *             {
 *                 CentralServerVmId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *                 SoftwareInstallationType = "External",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  workloads.SAPDatabaseTypeHANA,
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: workloads.SAPHighAvailabilityTypeAvailabilityZone,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 				SoftwareConfiguration: workloads.ExternalInstallationSoftwareConfiguration{
 * 					CentralServerVmId:        "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 					SoftwareInstallationType: "External",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("X00-RG")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(6)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E32ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E16ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .databaseType("HANA")
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("84sapha-gen2")
 *                                 .version("latest")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("{your-username}")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("xyz")
 *                                         .publicKey("abc")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .highAvailabilityConfig(HighAvailabilityConfigurationArgs.builder()
 *                         .highAvailabilityType("AvailabilityZone")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("xyz.test.com")
 *                     .build())
 *                 .softwareConfiguration(ExternalInstallationSoftwareConfigurationArgs.builder()
 *                     .centralServerVmId("/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0")
 *                     .softwareInstallationType("External")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Install SAP Software on Distributed System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "{{resourcegrp}}",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "8.2",
 *                             Version = "8.2.2021091201",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E4ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "8.2",
 *                             Version = "8.2.2021091201",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E4ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "8.2",
 *                             Version = "8.2.2021091201",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "sap.bpaas.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.SAPInstallWithoutOSConfigSoftwareConfigurationArgs
 *             {
 *                 BomUrl = "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
 *                 SapBitsStorageAccountId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 *                 SoftwareInstallationType = "SAPInstallWithoutOSConfig",
 *                 SoftwareVersion = "SAP S/4HANA 1909 SPS 03",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.Prod,
 *         Location = "eastus2",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags =
 *         {
 *             { "created by", "azureuser" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "{{resourcegrp}}",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "8.2",
 * 								Version:   "8.2.2021091201",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E4ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "8.2",
 * 								Version:   "8.2.2021091201",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E4ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "8.2",
 * 								Version:   "8.2.2021091201",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "sap.bpaas.com",
 * 				},
 * 				SoftwareConfiguration: workloads.SAPInstallWithoutOSConfigSoftwareConfiguration{
 * 					BomUrl:                   "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
 * 					SapBitsStorageAccountId:  "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 * 					SoftwareInstallationType: "SAPInstallWithoutOSConfig",
 * 					SoftwareVersion:          "SAP S/4HANA 1909 SPS 03",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeProd),
 * 			Location:               pulumi.String("eastus2"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags: pulumi.StringMap{
 * 				"created by": pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(ThreeTierConfigurationArgs.builder()
 *                     .appResourceGroup("{{resourcegrp}}")
 *                     .applicationServer(ApplicationServerConfigurationArgs.builder()
 *                         .instanceCount(2)
 *                         .subnetId("/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("8.2")
 *                                 .version("8.2.2021091201")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("azureuser")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("{{privateKey}}")
 *                                         .publicKey("{{sshkey}}")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E4ds_v4")
 *                             .build())
 *                         .build())
 *                     .centralServer(CentralServerConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("8.2")
 *                                 .version("8.2.2021091201")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("azureuser")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("{{privateKey}}")
 *                                         .publicKey("{{sshkey}}")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_E4ds_v4")
 *                             .build())
 *                         .build())
 *                     .databaseServer(DatabaseConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .subnetId("/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app")
 *                         .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                             .imageReference(ImageReferenceArgs.builder()
 *                                 .offer("RHEL-SAP-HA")
 *                                 .publisher("RedHat")
 *                                 .sku("8.2")
 *                                 .version("8.2.2021091201")
 *                                 .build())
 *                             .osProfile(OSProfileArgs.builder()
 *                                 .adminUsername("azureuser")
 *                                 .osConfiguration(LinuxConfigurationArgs.builder()
 *                                     .disablePasswordAuthentication(true)
 *                                     .osType("Linux")
 *                                     .sshKeyPair(SshKeyPairArgs.builder()
 *                                         .privateKey("{{privateKey}}")
 *                                         .publicKey("{{sshkey}}")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .vmSize("Standard_M32ts")
 *                             .build())
 *                         .build())
 *                     .deploymentType("ThreeTier")
 *                     .networkConfiguration(NetworkConfigurationArgs.builder()
 *                         .isSecondaryIpEnabled(true)
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("sap.bpaas.com")
 *                     .build())
 *                 .softwareConfiguration(SAPInstallWithoutOSConfigSoftwareConfigurationArgs.builder()
 *                     .bomUrl("https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml")
 *                     .sapBitsStorageAccountId("/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount")
 *                     .softwareInstallationType("SAPInstallWithoutOSConfig")
 *                     .softwareVersion("SAP S/4HANA 1909 SPS 03")
 *                     .build())
 *                 .build())
 *             .environment("Prod")
 *             .location("eastus2")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags(Map.of("created by", "azureuser"))
 *             .build());
 *     }
 * }
 * ```
 * ### Install SAP Software on Single Server System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "test-rg",
 *                 DeploymentType = "SingleServer",
 *                 SubnetId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/testsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "SLES-SAP",
 *                         Publisher = "SUSE",
 *                         Sku = "12-sp4-gen2",
 *                         Version = "2022.02.01",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "azureappadmin",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "{{privateKey}}",
 *                                 PublicKey = "{{sshkey}}",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "sap.bpaas.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.SAPInstallWithoutOSConfigSoftwareConfigurationArgs
 *             {
 *                 BomUrl = "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
 *                 SapBitsStorageAccountId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 *                 SoftwareInstallationType = "SAPInstallWithoutOSConfig",
 *                 SoftwareVersion = "SAP S/4HANA 1909 SPS 03",
 *             },
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.NonProd,
 *         Location = "eastus2",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "test-rg",
 * 					DeploymentType:   "SingleServer",
 * 					SubnetId:         "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/testsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "SLES-SAP",
 * 							Publisher: "SUSE",
 * 							Sku:       "12-sp4-gen2",
 * 							Version:   "2022.02.01",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "azureappadmin",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								SshKeyPair: workloads.SshKeyPair{
 * 									PrivateKey: "{{privateKey}}",
 * 									PublicKey:  "{{sshkey}}",
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "sap.bpaas.com",
 * 				},
 * 				SoftwareConfiguration: workloads.SAPInstallWithoutOSConfigSoftwareConfiguration{
 * 					BomUrl:                   "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
 * 					SapBitsStorageAccountId:  "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 * 					SoftwareInstallationType: "SAPInstallWithoutOSConfig",
 * 					SoftwareVersion:          "SAP S/4HANA 1909 SPS 03",
 * 				},
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeNonProd),
 * 			Location:               pulumi.String("eastus2"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DeploymentWithOSConfigurationArgs.builder()
 *                 .appLocation("eastus")
 *                 .configurationType("DeploymentWithOSConfig")
 *                 .infrastructureConfiguration(SingleServerConfigurationArgs.builder()
 *                     .appResourceGroup("test-rg")
 *                     .deploymentType("SingleServer")
 *                     .subnetId("/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/testsubnet")
 *                     .virtualMachineConfiguration(VirtualMachineConfigurationArgs.builder()
 *                         .imageReference(ImageReferenceArgs.builder()
 *                             .offer("SLES-SAP")
 *                             .publisher("SUSE")
 *                             .sku("12-sp4-gen2")
 *                             .version("2022.02.01")
 *                             .build())
 *                         .osProfile(OSProfileArgs.builder()
 *                             .adminUsername("azureappadmin")
 *                             .osConfiguration(LinuxConfigurationArgs.builder()
 *                                 .disablePasswordAuthentication(true)
 *                                 .osType("Linux")
 *                                 .sshKeyPair(SshKeyPairArgs.builder()
 *                                     .privateKey("{{privateKey}}")
 *                                     .publicKey("{{sshkey}}")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .vmSize("Standard_E32ds_v4")
 *                         .build())
 *                     .build())
 *                 .osSapConfiguration(OsSapConfigurationArgs.builder()
 *                     .sapFqdn("sap.bpaas.com")
 *                     .build())
 *                 .softwareConfiguration(SAPInstallWithoutOSConfigSoftwareConfigurationArgs.builder()
 *                     .bomUrl("https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml")
 *                     .sapBitsStorageAccountId("/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount")
 *                     .softwareInstallationType("SAPInstallWithoutOSConfig")
 *                     .softwareVersion("SAP S/4HANA 1909 SPS 03")
 *                     .build())
 *                 .build())
 *             .environment("NonProd")
 *             .location("eastus2")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Register existing SAP system as Virtual Instance for SAP solutions with optional customizations.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DiscoveryConfigurationArgs
 *         {
 *             CentralServerVmId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *             ConfigurationType = "Discovery",
 *             ManagedRgStorageAccountName = "q20saacssgrs",
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.NonProd,
 *         Location = "northeurope",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags =
 *         {
 *             { "createdby", "abc@microsoft.com" },
 *             { "test", "abc" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DiscoveryConfiguration{
 * 				CentralServerVmId:           "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 				ConfigurationType:           "Discovery",
 * 				ManagedRgStorageAccountName: "q20saacssgrs",
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeNonProd),
 * 			Location:               pulumi.String("northeurope"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags: pulumi.StringMap{
 * 				"createdby": pulumi.String("abc@microsoft.com"),
 * 				"test":      pulumi.String("abc"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DiscoveryConfigurationArgs.builder()
 *                 .centralServerVmId("/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0")
 *                 .configurationType("Discovery")
 *                 .managedRgStorageAccountName("q20saacssgrs")
 *                 .build())
 *             .environment("NonProd")
 *             .location("northeurope")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags(Map.ofEntries(
 *                 Map.entry("createdby", "abc@microsoft.com"),
 *                 Map.entry("test", "abc")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Register existing SAP system as Virtual Instance for SAP solutions.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DiscoveryConfigurationArgs
 *         {
 *             CentralServerVmId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *             ConfigurationType = "Discovery",
 *         },
 *         Environment = AzureNative.Workloads.SAPEnvironmentType.NonProd,
 *         Location = "northeurope",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = AzureNative.Workloads.SAPProductType.S4HANA,
 *         SapVirtualInstanceName = "X00",
 *         Tags =
 *         {
 *             { "createdby", "abc@microsoft.com" },
 *             { "test", "abc" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DiscoveryConfiguration{
 * 				CentralServerVmId: "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 				ConfigurationType: "Discovery",
 * 			},
 * 			Environment:            pulumi.String(workloads.SAPEnvironmentTypeNonProd),
 * 			Location:               pulumi.String("northeurope"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String(workloads.SAPProductTypeS4HANA),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags: pulumi.StringMap{
 * 				"createdby": pulumi.String("abc@microsoft.com"),
 * 				"test":      pulumi.String("abc"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(DiscoveryConfigurationArgs.builder()
 *                 .centralServerVmId("/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0")
 *                 .configurationType("Discovery")
 *                 .build())
 *             .environment("NonProd")
 *             .location("northeurope")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags(Map.ofEntries(
 *                 Map.entry("createdby", "abc@microsoft.com"),
 *                 Map.entry("test", "abc")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SAPVirtualInstance Q20 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}
 * ```
 */
public class SAPVirtualInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.SAPVirtualInstance,
) : KotlinCustomResource(javaResource, SAPVirtualInstanceMapper) {
    /**
     * Defines if the SAP system is being created using Azure Center for SAP solutions (ACSS) or if an existing SAP system is being registered with ACSS
     */
    public val configuration: Output<Any>
        get() = javaResource.configuration().applyValue({ args0 -> args0 })

    /**
     * Defines the environment type - Production/Non Production.
     */
    public val environment: Output<String>
        get() = javaResource.environment().applyValue({ args0 -> args0 })

    /**
     * Indicates any errors on the Virtual Instance for SAP solutions resource.
     */
    public val errors: Output<SAPVirtualInstanceErrorResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                sAPVirtualInstanceErrorResponseToKotlin(args0)
            })
        })

    /**
     * Defines the health of SAP Instances.
     */
    public val health: Output<String>
        get() = javaResource.health().applyValue({ args0 -> args0 })

    /**
     * A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit the ACSS how-to-guide.
     */
    public val identity: Output<UserAssignedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userAssignedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Managed resource group configuration
     */
    public val managedResourceGroupConfiguration: Output<ManagedRGConfigurationResponse>?
        get() = javaResource.managedResourceGroupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedRGConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines the SAP Product type.
     */
    public val sapProduct: Output<String>
        get() = javaResource.sapProduct().applyValue({ args0 -> args0 })

    /**
     * Defines the Virtual Instance for SAP state.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Defines the SAP Instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SAPVirtualInstanceMapper : ResourceMapper<SAPVirtualInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.SAPVirtualInstance::class == javaResource::class

    override fun map(javaResource: Resource): SAPVirtualInstance = SAPVirtualInstance(
        javaResource as
            com.pulumi.azurenative.workloads.SAPVirtualInstance,
    )
}

/**
 * @see [SAPVirtualInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SAPVirtualInstance].
 */
public suspend fun sapVirtualInstance(
    name: String,
    block: suspend SAPVirtualInstanceResourceBuilder.() -> Unit,
): SAPVirtualInstance {
    val builder = SAPVirtualInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SAPVirtualInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapVirtualInstance(name: String): SAPVirtualInstance {
    val builder = SAPVirtualInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
