@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.SapDiscoverySiteArgs.builder
import com.pulumi.azurenative.workloads.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the SAP Migration discovery site resource.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Create resource for Import based input.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapDiscoverySite = new AzureNative.Workloads.SapDiscoverySite("sapDiscoverySite", new()
 *     {
 *         Location = "eastus",
 *         MasterSiteId = "MasterSiteIdResourceId",
 *         MigrateProjectId = "MigrateProjectId",
 *         ResourceGroupName = "test-rg",
 *         SapDiscoverySiteName = "SampleSite",
 *         Tags =
 *         {
 *             { "property1", "value1" },
 *             { "property2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSapDiscoverySite(ctx, "sapDiscoverySite", &workloads.SapDiscoverySiteArgs{
 * 			Location:             pulumi.String("eastus"),
 * 			MasterSiteId:         pulumi.String("MasterSiteIdResourceId"),
 * 			MigrateProjectId:     pulumi.String("MigrateProjectId"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			SapDiscoverySiteName: pulumi.String("SampleSite"),
 * 			Tags: pulumi.StringMap{
 * 				"property1": pulumi.String("value1"),
 * 				"property2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SapDiscoverySite;
 * import com.pulumi.azurenative.workloads.SapDiscoverySiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapDiscoverySite = new SapDiscoverySite("sapDiscoverySite", SapDiscoverySiteArgs.builder()
 *             .location("eastus")
 *             .masterSiteId("MasterSiteIdResourceId")
 *             .migrateProjectId("MigrateProjectId")
 *             .resourceGroupName("test-rg")
 *             .sapDiscoverySiteName("SampleSite")
 *             .tags(Map.ofEntries(
 *                 Map.entry("property1", "value1"),
 *                 Map.entry("property2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SapDiscoverySite SampleSite /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}
 * ```
 * @property extendedLocation The extended location definition.
 * @property location The geo-location where the resource lives
 * @property masterSiteId The master site ID from Azure Migrate.
 * @property migrateProjectId The migrate project ID from Azure Migrate.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapDiscoverySiteName The name of the discovery site resource for SAP Migration.
 * @property tags Resource tags.
 */
public data class SapDiscoverySiteArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val masterSiteId: Output<String>? = null,
    public val migrateProjectId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sapDiscoverySiteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.SapDiscoverySiteArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.SapDiscoverySiteArgs =
        com.pulumi.azurenative.workloads.SapDiscoverySiteArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .masterSiteId(masterSiteId?.applyValue({ args0 -> args0 }))
            .migrateProjectId(migrateProjectId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sapDiscoverySiteName(sapDiscoverySiteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SapDiscoverySiteArgs].
 */
@PulumiTagMarker
public class SapDiscoverySiteArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var masterSiteId: Output<String>? = null

    private var migrateProjectId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sapDiscoverySiteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The extended location definition.
     */
    @JvmName("plvklgposldnyxgs")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pvxkeccepclkhudg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The master site ID from Azure Migrate.
     */
    @JvmName("dwrufxvvamfrrvfe")
    public suspend fun masterSiteId(`value`: Output<String>) {
        this.masterSiteId = value
    }

    /**
     * @param value The migrate project ID from Azure Migrate.
     */
    @JvmName("vwtdreaphkhkvpje")
    public suspend fun migrateProjectId(`value`: Output<String>) {
        this.migrateProjectId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pnntdjgpsvschhgf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("hpxvsbvbrrtjnyfo")
    public suspend fun sapDiscoverySiteName(`value`: Output<String>) {
        this.sapDiscoverySiteName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oeeyvjivqockukff")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The extended location definition.
     */
    @JvmName("hbpawkdpiryufgdn")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location definition.
     */
    @JvmName("sqocctfddmlgmnnx")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ioycvkoekdqkyodb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The master site ID from Azure Migrate.
     */
    @JvmName("bjlvihuvvmuviplm")
    public suspend fun masterSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterSiteId = mapped
    }

    /**
     * @param value The migrate project ID from Azure Migrate.
     */
    @JvmName("kpqjxtabrycqnlqq")
    public suspend fun migrateProjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateProjectId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wcstfcwowwybiwnd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("phnmwfqucorqfysj")
    public suspend fun sapDiscoverySiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapDiscoverySiteName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("obuxehiuftrewlbu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("pcekxbyfkaobqbyi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SapDiscoverySiteArgs = SapDiscoverySiteArgs(
        extendedLocation = extendedLocation,
        location = location,
        masterSiteId = masterSiteId,
        migrateProjectId = migrateProjectId,
        resourceGroupName = resourceGroupName,
        sapDiscoverySiteName = sapDiscoverySiteName,
        tags = tags,
    )
}
