@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse.Companion.toKotlin as sAPMigrateErrorResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SapInstance].
 */
@PulumiTagMarker
public class SapInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SapInstanceArgs = SapInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SapInstanceArgsBuilder.() -> Unit) {
        val builder = SapInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SapInstance {
        val builtJavaResource = com.pulumi.azurenative.workloads.SapInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SapInstance(builtJavaResource)
    }
}

/**
 * Define the SAP Instance resource.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Creates the SAP Instance resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapInstance = new AzureNative.Workloads.SapInstance("sapInstance", new()
 *     {
 *         Location = "eastus",
 *         ResourceGroupName = "test-rg",
 *         SapDiscoverySiteName = "SampleSite",
 *         SapInstanceName = "MPP_MPP",
 *         Tags =
 *         {
 *             { "property1", "value1" },
 *             { "property2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSapInstance(ctx, "sapInstance", &workloads.SapInstanceArgs{
 * 			Location:             pulumi.String("eastus"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			SapDiscoverySiteName: pulumi.String("SampleSite"),
 * 			SapInstanceName:      pulumi.String("MPP_MPP"),
 * 			Tags: pulumi.StringMap{
 * 				"property1": pulumi.String("value1"),
 * 				"property2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SapInstance;
 * import com.pulumi.azurenative.workloads.SapInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapInstance = new SapInstance("sapInstance", SapInstanceArgs.builder()
 *             .location("eastus")
 *             .resourceGroupName("test-rg")
 *             .sapDiscoverySiteName("SampleSite")
 *             .sapInstanceName("MPP_MPP")
 *             .tags(Map.ofEntries(
 *                 Map.entry("property1", "value1"),
 *                 Map.entry("property2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SapInstance MPP_MPP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}
 * ```
 */
public class SapInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.SapInstance,
) : KotlinCustomResource(javaResource, SapInstanceMapper) {
    /**
     * Enter a business function/department identifier to group multiple SIDs.
     */
    public val application: Output<String>
        get() = javaResource.application().applyValue({ args0 -> args0 })

    /**
     * The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select from the list of available dropdown values.
     */
    public val environment: Output<String>
        get() = javaResource.environment().applyValue({ args0 -> args0 })

    /**
     * Defines the errors related to SAP Instance resource.
     */
    public val errors: Output<SAPMigrateErrorResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                sAPMigrateErrorResponseToKotlin(args0)
            })
        })

    /**
     * This is the SID of the production system in a landscape.  An SAP system could itself be a production SID or a part of a landscape with a different Production SID. This field can be used to relate non-prod SIDs, other components, SID (WEBDISP) to the prod SID. Enter the value of Production SID.
     */
    public val landscapeSid: Output<String>
        get() = javaResource.landscapeSid().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * This is the SID of SAP System. Keeping this not equal to ID as different landscapes can have repeated System SID IDs.
     */
    public val systemSid: Output<String>
        get() = javaResource.systemSid().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SapInstanceMapper : ResourceMapper<SapInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.SapInstance::class == javaResource::class

    override fun map(javaResource: Resource): SapInstance = SapInstance(
        javaResource as
            com.pulumi.azurenative.workloads.SapInstance,
    )
}

/**
 * @see [SapInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SapInstance].
 */
public suspend fun sapInstance(name: String, block: suspend SapInstanceResourceBuilder.() -> Unit): SapInstance {
    val builder = SapInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SapInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapInstance(name: String): SapInstance {
    val builder = SapInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
