@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.ConfigurationDataResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.ExcelPerformanceDataResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.NativePerformanceDataResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.workloads.kotlin.outputs.ConfigurationDataResponse.Companion.toKotlin as configurationDataResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse.Companion.toKotlin as sAPMigrateErrorResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ServerInstance].
 */
@PulumiTagMarker
public class ServerInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerInstanceArgs = ServerInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerInstanceArgsBuilder.() -> Unit) {
        val builder = ServerInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerInstance {
        val builtJavaResource = com.pulumi.azurenative.workloads.ServerInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerInstance(builtJavaResource)
    }
}

/**
 * Define the Server Instance resource.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Creates the Server Instance resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverInstance = new AzureNative.Workloads.ServerInstance("serverInstance", new()
 *     {
 *         ResourceGroupName = "test-rg",
 *         SapDiscoverySiteName = "SampleSite",
 *         SapInstanceName = "MPP_MPP",
 *         ServerInstanceName = "APP_SapServer1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewServerInstance(ctx, "serverInstance", &workloads.ServerInstanceArgs{
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 			SapDiscoverySiteName: pulumi.String("SampleSite"),
 * 			SapInstanceName:      pulumi.String("MPP_MPP"),
 * 			ServerInstanceName:   pulumi.String("APP_SapServer1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ServerInstance;
 * import com.pulumi.azurenative.workloads.ServerInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverInstance = new ServerInstance("serverInstance", ServerInstanceArgs.builder()
 *             .resourceGroupName("test-rg")
 *             .sapDiscoverySiteName("SampleSite")
 *             .sapInstanceName("MPP_MPP")
 *             .serverInstanceName("APP_SapServer1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:ServerInstance APP_SapServer1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}/serverInstances/{serverInstanceName}
 * ```
 */
public class ServerInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.ServerInstance,
) : KotlinCustomResource(javaResource, ServerInstanceMapper) {
    /**
     * Configuration data for this server instance.
     */
    public val configurationData: Output<ConfigurationDataResponse>
        get() = javaResource.configurationData().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationDataResponseToKotlin(args0)
            })
        })

    /**
     * Defines the errors related to SAP Instance resource.
     */
    public val errors: Output<SAPMigrateErrorResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                sAPMigrateErrorResponseToKotlin(args0)
            })
        })

    /**
     * This is the Instance SID for ASCS/AP/DB instance.  An SAP system with HANA database for example could have a different SID for database Instance than that of ASCS instance.
     */
    public val instanceSid: Output<String>
        get() = javaResource.instanceSid().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * This is Operating System on which the host server is running.
     */
    public val operatingSystem: Output<String>
        get() = javaResource.operatingSystem().applyValue({ args0 -> args0 })

    /**
     * Configuration data for this server instance.
     */
    public val performanceData:
        Output<Either<ExcelPerformanceDataResponse, NativePerformanceDataResponse>>
        get() = javaResource.performanceData().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.ExcelPerformanceDataResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.NativePerformanceDataResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines the type SAP instance on this server instance.
     */
    public val sapInstanceType: Output<String>
        get() = javaResource.sapInstanceType().applyValue({ args0 -> args0 })

    /**
     * This is the SAP Application Component; e.g. SAP S/4HANA 2022, SAP ERP ENHANCE PACKAGE.
     */
    public val sapProduct: Output<String>
        get() = javaResource.sapProduct().applyValue({ args0 -> args0 })

    /**
     * Provide the product version of the SAP product.
     */
    public val sapProductVersion: Output<String>
        get() = javaResource.sapProductVersion().applyValue({ args0 -> args0 })

    /**
     * This is the Virtual Machine Name of the SAP system. Add all the virtual machines attached to an SAP system which you wish to migrate to Azure. Keeping this not equal to ID as for single tier all InstanceTypes would be on same server, leading to multiple resources with same servername.
     */
    public val serverName: Output<String>
        get() = javaResource.serverName().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerInstanceMapper : ResourceMapper<ServerInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.ServerInstance::class == javaResource::class

    override fun map(javaResource: Resource): ServerInstance = ServerInstance(
        javaResource as
            com.pulumi.azurenative.workloads.ServerInstance,
    )
}

/**
 * @see [ServerInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerInstance].
 */
public suspend fun serverInstance(
    name: String,
    block: suspend ServerInstanceResourceBuilder.() -> Unit,
): ServerInstance {
    val builder = ServerInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverInstance(name: String): ServerInstance {
    val builder = ServerInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
