@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of backup policy type
 */
public enum class PolicyType(
    public val javaValue: com.pulumi.azurenative.workloads.enums.PolicyType,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.PolicyType> {
    Invalid(com.pulumi.azurenative.workloads.enums.PolicyType.Invalid),
    Full(com.pulumi.azurenative.workloads.enums.PolicyType.Full),
    Differential(com.pulumi.azurenative.workloads.enums.PolicyType.Differential),
    Log(com.pulumi.azurenative.workloads.enums.PolicyType.Log),
    CopyOnlyFull(com.pulumi.azurenative.workloads.enums.PolicyType.CopyOnlyFull),
    Incremental(com.pulumi.azurenative.workloads.enums.PolicyType.Incremental),
    SnapshotFull(com.pulumi.azurenative.workloads.enums.PolicyType.SnapshotFull),
    SnapshotCopyOnlyFull(com.pulumi.azurenative.workloads.enums.PolicyType.SnapshotCopyOnlyFull),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.PolicyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.PolicyType): PolicyType =
            PolicyType.values().first { it.javaValue == javaType }
    }
}
