@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
 */
public enum class RoutingPreference(
    public val javaValue: com.pulumi.azurenative.workloads.enums.RoutingPreference,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.RoutingPreference> {
    Default(com.pulumi.azurenative.workloads.enums.RoutingPreference.Default),
    RouteAll(com.pulumi.azurenative.workloads.enums.RoutingPreference.RouteAll),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.RoutingPreference = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.RoutingPreference): RoutingPreference = RoutingPreference.values().first { it.javaValue == javaType }
    }
}
