@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The database type. Eg: HANA, DB2, etc
 */
public enum class SAPDatabaseType(
    public val javaValue: com.pulumi.azurenative.workloads.enums.SAPDatabaseType,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.SAPDatabaseType> {
    HANA(com.pulumi.azurenative.workloads.enums.SAPDatabaseType.HANA),
    DB2(com.pulumi.azurenative.workloads.enums.SAPDatabaseType.DB2),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.SAPDatabaseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.SAPDatabaseType): SAPDatabaseType = SAPDatabaseType.values().first { it.javaValue == javaType }
    }
}
