@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The deployment type. Eg: SingleServer/ThreeTier
 */
public enum class SAPDeploymentType(
    public val javaValue: com.pulumi.azurenative.workloads.enums.SAPDeploymentType,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.SAPDeploymentType> {
    SingleServer(com.pulumi.azurenative.workloads.enums.SAPDeploymentType.SingleServer),
    ThreeTier(com.pulumi.azurenative.workloads.enums.SAPDeploymentType.ThreeTier),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.SAPDeploymentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.SAPDeploymentType): SAPDeploymentType = SAPDeploymentType.values().first { it.javaValue == javaType }
    }
}
