@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines the SAP Product type.
 */
public enum class SAPProductType(
    public val javaValue: com.pulumi.azurenative.workloads.enums.SAPProductType,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.SAPProductType> {
    ECC(com.pulumi.azurenative.workloads.enums.SAPProductType.ECC),
    S4HANA(com.pulumi.azurenative.workloads.enums.SAPProductType.S4HANA),
    Other(com.pulumi.azurenative.workloads.enums.SAPProductType.Other),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.SAPProductType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.SAPProductType): SAPProductType = SAPProductType.values().first { it.javaValue == javaType }
    }
}
