@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets certificate preference if secure communication is enabled.
 */
public enum class SslPreference(
    public val javaValue: com.pulumi.azurenative.workloads.enums.SslPreference,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.SslPreference> {
    Disabled(com.pulumi.azurenative.workloads.enums.SslPreference.Disabled),
    RootCertificate(com.pulumi.azurenative.workloads.enums.SslPreference.RootCertificate),
    ServerCertificate(com.pulumi.azurenative.workloads.enums.SslPreference.ServerCertificate),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.SslPreference = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.SslPreference): SslPreference = SslPreference.values().first { it.javaValue == javaType }
    }
}
