@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of workload for the backup management
 */
public enum class WorkloadType(
    public val javaValue: com.pulumi.azurenative.workloads.enums.WorkloadType,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.WorkloadType> {
    Invalid(com.pulumi.azurenative.workloads.enums.WorkloadType.Invalid),
    VM(com.pulumi.azurenative.workloads.enums.WorkloadType.VM),
    FileFolder(com.pulumi.azurenative.workloads.enums.WorkloadType.FileFolder),
    AzureSqlDb(com.pulumi.azurenative.workloads.enums.WorkloadType.AzureSqlDb),
    SQLDB(com.pulumi.azurenative.workloads.enums.WorkloadType.SQLDB),
    Exchange(com.pulumi.azurenative.workloads.enums.WorkloadType.Exchange),
    Sharepoint(com.pulumi.azurenative.workloads.enums.WorkloadType.Sharepoint),
    VMwareVM(com.pulumi.azurenative.workloads.enums.WorkloadType.VMwareVM),
    SystemState(com.pulumi.azurenative.workloads.enums.WorkloadType.SystemState),
    Client(com.pulumi.azurenative.workloads.enums.WorkloadType.Client),
    GenericDataSource(com.pulumi.azurenative.workloads.enums.WorkloadType.GenericDataSource),
    SQLDataBase(com.pulumi.azurenative.workloads.enums.WorkloadType.SQLDataBase),
    AzureFileShare(com.pulumi.azurenative.workloads.enums.WorkloadType.AzureFileShare),
    SAPHanaDatabase(com.pulumi.azurenative.workloads.enums.WorkloadType.SAPHanaDatabase),
    SAPAseDatabase(com.pulumi.azurenative.workloads.enums.WorkloadType.SAPAseDatabase),
    SAPHanaDBInstance(com.pulumi.azurenative.workloads.enums.WorkloadType.SAPHanaDBInstance),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.WorkloadType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.WorkloadType): WorkloadType = WorkloadType.values().first { it.javaValue == javaType }
    }
}
