@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DBBackupPolicyPropertiesArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.WorkloadType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the policy properties for database backup.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureWorkload'.
 * @property makePolicyConsistent Fix the policy inconsistency
 * @property name The name of the DB backup policy.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property settings Common settings for the backup management
 * @property subProtectionPolicy List of sub-protection policies which includes schedule and retention
 * @property workLoadType Type of workload for the backup management
 */
public data class DBBackupPolicyPropertiesArgs(
    public val backupManagementType: Output<String>,
    public val makePolicyConsistent: Output<Boolean>? = null,
    public val name: Output<String>,
    public val protectedItemsCount: Output<Int>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val settings: Output<SettingsArgs>? = null,
    public val subProtectionPolicy: Output<List<SubProtectionPolicyArgs>>? = null,
    public val workLoadType: Output<Either<String, WorkloadType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DBBackupPolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DBBackupPolicyPropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.DBBackupPolicyPropertiesArgs.builder()
            .backupManagementType(backupManagementType.applyValue({ args0 -> args0 }))
            .makePolicyConsistent(makePolicyConsistent?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .protectedItemsCount(protectedItemsCount?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subProtectionPolicy(
                subProtectionPolicy?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .workLoadType(
                workLoadType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DBBackupPolicyPropertiesArgs].
 */
@PulumiTagMarker
public class DBBackupPolicyPropertiesArgsBuilder internal constructor() {
    private var backupManagementType: Output<String>? = null

    private var makePolicyConsistent: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var protectedItemsCount: Output<Int>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var settings: Output<SettingsArgs>? = null

    private var subProtectionPolicy: Output<List<SubProtectionPolicyArgs>>? = null

    private var workLoadType: Output<Either<String, WorkloadType>>? = null

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureWorkload'.
     */
    @JvmName("wygricgqlnlweuqh")
    public suspend fun backupManagementType(`value`: Output<String>) {
        this.backupManagementType = value
    }

    /**
     * @param value Fix the policy inconsistency
     */
    @JvmName("krvfavukqnyweucl")
    public suspend fun makePolicyConsistent(`value`: Output<Boolean>) {
        this.makePolicyConsistent = value
    }

    /**
     * @param value The name of the DB backup policy.
     */
    @JvmName("fqmonjvohcjcmnro")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("ekcnraaqadvsnsry")
    public suspend fun protectedItemsCount(`value`: Output<Int>) {
        this.protectedItemsCount = value
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("fitbmwhlfgnrshpy")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("kpsxnkgrufihyywu")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("rjlidfbcplcgptma")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Common settings for the backup management
     */
    @JvmName("jlkmqlhtvhpuwekj")
    public suspend fun settings(`value`: Output<SettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value List of sub-protection policies which includes schedule and retention
     */
    @JvmName("lltuvmavvtjgejbb")
    public suspend fun subProtectionPolicy(`value`: Output<List<SubProtectionPolicyArgs>>) {
        this.subProtectionPolicy = value
    }

    @JvmName("nwyjulxuybcoowrg")
    public suspend fun subProtectionPolicy(vararg values: Output<SubProtectionPolicyArgs>) {
        this.subProtectionPolicy = Output.all(values.asList())
    }

    /**
     * @param values List of sub-protection policies which includes schedule and retention
     */
    @JvmName("jspoqslakjkwbwqw")
    public suspend fun subProtectionPolicy(values: List<Output<SubProtectionPolicyArgs>>) {
        this.subProtectionPolicy = Output.all(values)
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("kilyxdrjjyehqvlt")
    public suspend fun workLoadType(`value`: Output<Either<String, WorkloadType>>) {
        this.workLoadType = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureWorkload'.
     */
    @JvmName("syjbalicnlfbrmou")
    public suspend fun backupManagementType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Fix the policy inconsistency
     */
    @JvmName("jaegjgekorxjrpft")
    public suspend fun makePolicyConsistent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.makePolicyConsistent = mapped
    }

    /**
     * @param value The name of the DB backup policy.
     */
    @JvmName("yfvscvbnfcoheghc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("epewmfgoiaddefjk")
    public suspend fun protectedItemsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemsCount = mapped
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("clvqohfbcqcvxgjl")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("befhrwhjtvsysaeg")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Common settings for the backup management
     */
    @JvmName("sgbtmoeuwiwaukxe")
    public suspend fun settings(`value`: SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Common settings for the backup management
     */
    @JvmName("vufuchxqhnawpaoq")
    public suspend fun settings(argument: suspend SettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value List of sub-protection policies which includes schedule and retention
     */
    @JvmName("ojcjyrvllwjyktie")
    public suspend fun subProtectionPolicy(`value`: List<SubProtectionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("yaxwifaeuscwuccy")
    public suspend fun subProtectionPolicy(argument: List<suspend SubProtectionPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubProtectionPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("dkgpaqmqoankurfb")
    public suspend fun subProtectionPolicy(vararg argument: suspend SubProtectionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SubProtectionPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param argument List of sub-protection policies which includes schedule and retention
     */
    @JvmName("gairgfobfyetbijf")
    public suspend fun subProtectionPolicy(argument: suspend SubProtectionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubProtectionPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subProtectionPolicy = mapped
    }

    /**
     * @param values List of sub-protection policies which includes schedule and retention
     */
    @JvmName("sfueedlthvkqxcqj")
    public suspend fun subProtectionPolicy(vararg values: SubProtectionPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subProtectionPolicy = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("wtgxdkeffajnejqy")
    public suspend fun workLoadType(`value`: Either<String, WorkloadType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("asqgwrackedrcnjy")
    public fun workLoadType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    /**
     * @param value Type of workload for the backup management
     */
    @JvmName("qmprubdwyxmvdmks")
    public fun workLoadType(`value`: WorkloadType) {
        val toBeMapped = Either.ofRight<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workLoadType = mapped
    }

    internal fun build(): DBBackupPolicyPropertiesArgs = DBBackupPolicyPropertiesArgs(
        backupManagementType = backupManagementType ?: throw
            PulumiNullFieldException("backupManagementType"),
        makePolicyConsistent = makePolicyConsistent,
        name = name ?: throw PulumiNullFieldException("name"),
        protectedItemsCount = protectedItemsCount,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        settings = settings,
        subProtectionPolicy = subProtectionPolicy,
        workLoadType = workLoadType,
    )
}
