@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.ExistingRecoveryServicesVaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Existing recovery services vault.
 * @property id The resource ID of the recovery services vault that has been created.
 * @property vaultType The vault type, whether it is existing or has to be created.
 * Expected value is 'Existing'.
 */
public data class ExistingRecoveryServicesVaultArgs(
    public val id: Output<String>,
    public val vaultType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.ExistingRecoveryServicesVaultArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.ExistingRecoveryServicesVaultArgs =
        com.pulumi.azurenative.workloads.inputs.ExistingRecoveryServicesVaultArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .vaultType(vaultType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExistingRecoveryServicesVaultArgs].
 */
@PulumiTagMarker
public class ExistingRecoveryServicesVaultArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var vaultType: Output<String>? = null

    /**
     * @param value The resource ID of the recovery services vault that has been created.
     */
    @JvmName("eobnnqmecashpoam")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The vault type, whether it is existing or has to be created.
     * Expected value is 'Existing'.
     */
    @JvmName("wrpwupyhkqgrnlxi")
    public suspend fun vaultType(`value`: Output<String>) {
        this.vaultType = value
    }

    /**
     * @param value The resource ID of the recovery services vault that has been created.
     */
    @JvmName("ddhwlkffwamsmcyd")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The vault type, whether it is existing or has to be created.
     * Expected value is 'Existing'.
     */
    @JvmName("jekgxhcumfhiucos")
    public suspend fun vaultType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultType = mapped
    }

    internal fun build(): ExistingRecoveryServicesVaultArgs = ExistingRecoveryServicesVaultArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        vaultType = vaultType ?: throw PulumiNullFieldException("vaultType"),
    )
}
