@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetACSSBackupConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property backupName The name of the backup connection resource of virtual instance for SAP.
 * @property connectorName The name of the connector resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetACSSBackupConnectionPlainArgs(
    public val backupName: String,
    public val connectorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetACSSBackupConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetACSSBackupConnectionPlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetACSSBackupConnectionPlainArgs.builder()
            .backupName(backupName.let({ args0 -> args0 }))
            .connectorName(connectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetACSSBackupConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetACSSBackupConnectionPlainArgsBuilder internal constructor() {
    private var backupName: String? = null

    private var connectorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the backup connection resource of virtual instance for SAP.
     */
    @JvmName("unoxvbtlngqiwxus")
    public suspend fun backupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backupName = mapped
    }

    /**
     * @param value The name of the connector resource
     */
    @JvmName("qtkwtuaxdnwwoneu")
    public suspend fun connectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gyecfhnnemdfayqb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetACSSBackupConnectionPlainArgs = GetACSSBackupConnectionPlainArgs(
        backupName = backupName ?: throw PulumiNullFieldException("backupName"),
        connectorName = connectorName ?: throw PulumiNullFieldException("connectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
