@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectorName The name of the connector resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConnectorPlainArgs(
    public val connectorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetConnectorPlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetConnectorPlainArgs.builder()
            .connectorName(connectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetConnectorPlainArgsBuilder internal constructor() {
    private var connectorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the connector resource
     */
    @JvmName("pgrstijbtxpgkori")
    public suspend fun connectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rpnornhjvlkhpjix")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectorPlainArgs = GetConnectorPlainArgs(
        connectorName = connectorName ?: throw PulumiNullFieldException("connectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
