@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSAPAvailabilityZoneDetailsPlainArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPProductType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appLocation The geo-location where the SAP resources will be created.
 * @property databaseType The database type. Eg: HANA, DB2, etc
 * @property location The name of Azure region.
 * @property sapProduct Defines the SAP Product type.
 */
public data class GetSAPAvailabilityZoneDetailsPlainArgs(
    public val appLocation: String,
    public val databaseType: Either<String, SAPDatabaseType>,
    public val location: String,
    public val sapProduct: Either<String, SAPProductType>,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSAPAvailabilityZoneDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetSAPAvailabilityZoneDetailsPlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSAPAvailabilityZoneDetailsPlainArgs.builder()
            .appLocation(appLocation.let({ args0 -> args0 }))
            .databaseType(
                databaseType.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location.let({ args0 -> args0 }))
            .sapProduct(
                sapProduct.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetSAPAvailabilityZoneDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetSAPAvailabilityZoneDetailsPlainArgsBuilder internal constructor() {
    private var appLocation: String? = null

    private var databaseType: Either<String, SAPDatabaseType>? = null

    private var location: String? = null

    private var sapProduct: Either<String, SAPProductType>? = null

    /**
     * @param value The geo-location where the SAP resources will be created.
     */
    @JvmName("yrpidrrysgatquhh")
    public suspend fun appLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appLocation = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("qfrfkxraehkythic")
    public suspend fun databaseType(`value`: Either<String, SAPDatabaseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("qbjhlvwhaefvfecb")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("csqbnqohdiawtdnw")
    public fun databaseType(`value`: SAPDatabaseType) {
        val toBeMapped = Either.ofRight<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The name of Azure region.
     */
    @JvmName("asbxycndxmlkcnmr")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("pvcasxamltqwicth")
    public suspend fun sapProduct(`value`: Either<String, SAPProductType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("miknhyyylayodfas")
    public fun sapProduct(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPProductType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("bdvmtooopvgkiaat")
    public fun sapProduct(`value`: SAPProductType) {
        val toBeMapped = Either.ofRight<String, SAPProductType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    internal fun build(): GetSAPAvailabilityZoneDetailsPlainArgs =
        GetSAPAvailabilityZoneDetailsPlainArgs(
            appLocation = appLocation ?: throw PulumiNullFieldException("appLocation"),
            databaseType = databaseType ?: throw PulumiNullFieldException("databaseType"),
            location = location ?: throw PulumiNullFieldException("location"),
            sapProduct = sapProduct ?: throw PulumiNullFieldException("sapProduct"),
        )
}
