@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSapDiscoverySitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapDiscoverySiteName The name of the discovery site resource for SAP Migration.
 */
public data class GetSapDiscoverySitePlainArgs(
    public val resourceGroupName: String,
    public val sapDiscoverySiteName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSapDiscoverySitePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetSapDiscoverySitePlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSapDiscoverySitePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapDiscoverySiteName(sapDiscoverySiteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSapDiscoverySitePlainArgs].
 */
@PulumiTagMarker
public class GetSapDiscoverySitePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sapDiscoverySiteName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ylhwtraehuxnaide")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("vcvfmnvvhlupwuex")
    public suspend fun sapDiscoverySiteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapDiscoverySiteName = mapped
    }

    internal fun build(): GetSapDiscoverySitePlainArgs = GetSapDiscoverySitePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sapDiscoverySiteName = sapDiscoverySiteName ?: throw
            PulumiNullFieldException("sapDiscoverySiteName"),
    )
}
