@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSapInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapDiscoverySiteName The name of the discovery site resource for SAP Migration.
 * @property sapInstanceName The name of SAP Instance resource for SAP Migration.
 */
public data class GetSapInstancePlainArgs(
    public val resourceGroupName: String,
    public val sapDiscoverySiteName: String,
    public val sapInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSapInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetSapInstancePlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSapInstancePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapDiscoverySiteName(sapDiscoverySiteName.let({ args0 -> args0 }))
            .sapInstanceName(sapInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSapInstancePlainArgs].
 */
@PulumiTagMarker
public class GetSapInstancePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sapDiscoverySiteName: String? = null

    private var sapInstanceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tlxjydofdgtxemin")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the discovery site resource for SAP Migration.
     */
    @JvmName("atgthwpljfdjikfd")
    public suspend fun sapDiscoverySiteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapDiscoverySiteName = mapped
    }

    /**
     * @param value The name of SAP Instance resource for SAP Migration.
     */
    @JvmName("pxmxkkrsennlejgv")
    public suspend fun sapInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapInstanceName = mapped
    }

    internal fun build(): GetSapInstancePlainArgs = GetSapInstancePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sapDiscoverySiteName = sapDiscoverySiteName ?: throw
            PulumiNullFieldException("sapDiscoverySiteName"),
        sapInstanceName = sapInstanceName ?: throw PulumiNullFieldException("sapInstanceName"),
    )
}
