@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.HourlyScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Hourly schedule.
 * @property interval Interval at which backup needs to be triggered. For hourly the value
 *  can be 4/6/8/12
 * @property scheduleWindowDuration To specify duration of the backup window
 * @property scheduleWindowStartTime To specify start time of the backup window
 */
public data class HourlyScheduleArgs(
    public val interval: Output<Int>? = null,
    public val scheduleWindowDuration: Output<Int>? = null,
    public val scheduleWindowStartTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.HourlyScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.HourlyScheduleArgs =
        com.pulumi.azurenative.workloads.inputs.HourlyScheduleArgs.builder()
            .interval(interval?.applyValue({ args0 -> args0 }))
            .scheduleWindowDuration(scheduleWindowDuration?.applyValue({ args0 -> args0 }))
            .scheduleWindowStartTime(scheduleWindowStartTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HourlyScheduleArgs].
 */
@PulumiTagMarker
public class HourlyScheduleArgsBuilder internal constructor() {
    private var interval: Output<Int>? = null

    private var scheduleWindowDuration: Output<Int>? = null

    private var scheduleWindowStartTime: Output<String>? = null

    /**
     * @param value Interval at which backup needs to be triggered. For hourly the value
     *  can be 4/6/8/12
     */
    @JvmName("goievbpuucoocojo")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value To specify duration of the backup window
     */
    @JvmName("fmkcgresnotkkjcu")
    public suspend fun scheduleWindowDuration(`value`: Output<Int>) {
        this.scheduleWindowDuration = value
    }

    /**
     * @param value To specify start time of the backup window
     */
    @JvmName("osxhyligyibtpves")
    public suspend fun scheduleWindowStartTime(`value`: Output<String>) {
        this.scheduleWindowStartTime = value
    }

    /**
     * @param value Interval at which backup needs to be triggered. For hourly the value
     *  can be 4/6/8/12
     */
    @JvmName("quhemvfuvagevqpp")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value To specify duration of the backup window
     */
    @JvmName("uivlqhelysayphpa")
    public suspend fun scheduleWindowDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleWindowDuration = mapped
    }

    /**
     * @param value To specify start time of the backup window
     */
    @JvmName("fqfhdqhbaelhcujf")
    public suspend fun scheduleWindowStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleWindowStartTime = mapped
    }

    internal fun build(): HourlyScheduleArgs = HourlyScheduleArgs(
        interval = interval,
        scheduleWindowDuration = scheduleWindowDuration,
        scheduleWindowStartTime = scheduleWindowStartTime,
    )
}
