@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SAPInstallWithoutOSConfigSoftwareConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The SAP Software configuration Input when the software is to be installed by service without OS Configurations
 * @property bomUrl The URL to the SAP Build of Materials(BOM) file.
 * @property highAvailabilitySoftwareConfiguration Gets or sets the HA software configuration.
 * @property sapBitsStorageAccountId The SAP bits storage account id.
 * @property softwareInstallationType The SAP software installation Type.
 * Expected value is 'SAPInstallWithoutOSConfig'.
 * @property softwareVersion The software version to install.
 */
public data class SAPInstallWithoutOSConfigSoftwareConfigurationArgs(
    public val bomUrl: Output<String>,
    public val highAvailabilitySoftwareConfiguration: Output<HighAvailabilitySoftwareConfigurationArgs>? = null,
    public val sapBitsStorageAccountId: Output<String>,
    public val softwareInstallationType: Output<String>,
    public val softwareVersion: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SAPInstallWithoutOSConfigSoftwareConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SAPInstallWithoutOSConfigSoftwareConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.SAPInstallWithoutOSConfigSoftwareConfigurationArgs.builder()
            .bomUrl(bomUrl.applyValue({ args0 -> args0 }))
            .highAvailabilitySoftwareConfiguration(
                highAvailabilitySoftwareConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sapBitsStorageAccountId(sapBitsStorageAccountId.applyValue({ args0 -> args0 }))
            .softwareInstallationType(softwareInstallationType.applyValue({ args0 -> args0 }))
            .softwareVersion(softwareVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SAPInstallWithoutOSConfigSoftwareConfigurationArgs].
 */
@PulumiTagMarker
public class SAPInstallWithoutOSConfigSoftwareConfigurationArgsBuilder internal constructor() {
    private var bomUrl: Output<String>? = null

    private var highAvailabilitySoftwareConfiguration:
        Output<HighAvailabilitySoftwareConfigurationArgs>? = null

    private var sapBitsStorageAccountId: Output<String>? = null

    private var softwareInstallationType: Output<String>? = null

    private var softwareVersion: Output<String>? = null

    /**
     * @param value The URL to the SAP Build of Materials(BOM) file.
     */
    @JvmName("qwffheedsemoptpa")
    public suspend fun bomUrl(`value`: Output<String>) {
        this.bomUrl = value
    }

    /**
     * @param value Gets or sets the HA software configuration.
     */
    @JvmName("frxavgbuqalomaco")
    public suspend fun highAvailabilitySoftwareConfiguration(`value`: Output<HighAvailabilitySoftwareConfigurationArgs>) {
        this.highAvailabilitySoftwareConfiguration = value
    }

    /**
     * @param value The SAP bits storage account id.
     */
    @JvmName("ljiagrvxryngwbtp")
    public suspend fun sapBitsStorageAccountId(`value`: Output<String>) {
        this.sapBitsStorageAccountId = value
    }

    /**
     * @param value The SAP software installation Type.
     * Expected value is 'SAPInstallWithoutOSConfig'.
     */
    @JvmName("krfpbesoemqytuyr")
    public suspend fun softwareInstallationType(`value`: Output<String>) {
        this.softwareInstallationType = value
    }

    /**
     * @param value The software version to install.
     */
    @JvmName("ideeygrpopbixdud")
    public suspend fun softwareVersion(`value`: Output<String>) {
        this.softwareVersion = value
    }

    /**
     * @param value The URL to the SAP Build of Materials(BOM) file.
     */
    @JvmName("vpcxhukdduxmarsl")
    public suspend fun bomUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bomUrl = mapped
    }

    /**
     * @param value Gets or sets the HA software configuration.
     */
    @JvmName("mvsrptaxjeqkioiq")
    public suspend fun highAvailabilitySoftwareConfiguration(`value`: HighAvailabilitySoftwareConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highAvailabilitySoftwareConfiguration = mapped
    }

    /**
     * @param argument Gets or sets the HA software configuration.
     */
    @JvmName("pphvulbfsxwlamrh")
    public suspend fun highAvailabilitySoftwareConfiguration(argument: suspend HighAvailabilitySoftwareConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = HighAvailabilitySoftwareConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.highAvailabilitySoftwareConfiguration = mapped
    }

    /**
     * @param value The SAP bits storage account id.
     */
    @JvmName("llglkjexcncqgsce")
    public suspend fun sapBitsStorageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sapBitsStorageAccountId = mapped
    }

    /**
     * @param value The SAP software installation Type.
     * Expected value is 'SAPInstallWithoutOSConfig'.
     */
    @JvmName("stqyoqrutvdchmvm")
    public suspend fun softwareInstallationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareInstallationType = mapped
    }

    /**
     * @param value The software version to install.
     */
    @JvmName("ebiitemnolckedgg")
    public suspend fun softwareVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareVersion = mapped
    }

    internal fun build(): SAPInstallWithoutOSConfigSoftwareConfigurationArgs =
        SAPInstallWithoutOSConfigSoftwareConfigurationArgs(
            bomUrl = bomUrl ?: throw PulumiNullFieldException("bomUrl"),
            highAvailabilitySoftwareConfiguration = highAvailabilitySoftwareConfiguration,
            sapBitsStorageAccountId = sapBitsStorageAccountId ?: throw
                PulumiNullFieldException("sapBitsStorageAccountId"),
            softwareInstallationType = softwareInstallationType ?: throw
                PulumiNullFieldException("softwareInstallationType"),
            softwareVersion = softwareVersion ?: throw PulumiNullFieldException("softwareVersion"),
        )
}
