@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SingleServerConfigurationArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Gets or sets the single server configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
 * @property appResourceGroup The application resource group where SAP system resources will be deployed.
 * @property customResourceNames The set of custom names to be used for underlying azure resources that are part of the SAP system.
 * @property databaseType The database type.
 * @property dbDiskConfiguration Gets or sets the disk configuration.
 * @property deploymentType The type of SAP deployment, single server or Three tier.
 * Expected value is 'SingleServer'.
 * @property networkConfiguration Network configuration for the server
 * @property subnetId The subnet id.
 * @property virtualMachineConfiguration Gets or sets the virtual machine configuration.
 */
public data class SingleServerConfigurationArgs(
    public val appResourceGroup: Output<String>,
    public val customResourceNames: Output<SingleServerFullResourceNamesArgs>? = null,
    public val databaseType: Output<Either<String, SAPDatabaseType>>? = null,
    public val dbDiskConfiguration: Output<DiskConfigurationArgs>? = null,
    public val deploymentType: Output<String>,
    public val networkConfiguration: Output<NetworkConfigurationArgs>? = null,
    public val subnetId: Output<String>,
    public val virtualMachineConfiguration: Output<VirtualMachineConfigurationArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SingleServerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SingleServerConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.SingleServerConfigurationArgs.builder()
            .appResourceGroup(appResourceGroup.applyValue({ args0 -> args0 }))
            .customResourceNames(
                customResourceNames?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .databaseType(
                databaseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dbDiskConfiguration(
                dbDiskConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deploymentType(deploymentType.applyValue({ args0 -> args0 }))
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .subnetId(subnetId.applyValue({ args0 -> args0 }))
            .virtualMachineConfiguration(
                virtualMachineConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SingleServerConfigurationArgs].
 */
@PulumiTagMarker
public class SingleServerConfigurationArgsBuilder internal constructor() {
    private var appResourceGroup: Output<String>? = null

    private var customResourceNames: Output<SingleServerFullResourceNamesArgs>? = null

    private var databaseType: Output<Either<String, SAPDatabaseType>>? = null

    private var dbDiskConfiguration: Output<DiskConfigurationArgs>? = null

    private var deploymentType: Output<String>? = null

    private var networkConfiguration: Output<NetworkConfigurationArgs>? = null

    private var subnetId: Output<String>? = null

    private var virtualMachineConfiguration: Output<VirtualMachineConfigurationArgs>? = null

    /**
     * @param value The application resource group where SAP system resources will be deployed.
     */
    @JvmName("hdgpxhgvxgwbeupg")
    public suspend fun appResourceGroup(`value`: Output<String>) {
        this.appResourceGroup = value
    }

    /**
     * @param value The set of custom names to be used for underlying azure resources that are part of the SAP system.
     */
    @JvmName("ehoapvqqlbxhkgrd")
    public suspend fun customResourceNames(`value`: Output<SingleServerFullResourceNamesArgs>) {
        this.customResourceNames = value
    }

    /**
     * @param value The database type.
     */
    @JvmName("rrldekhbmwpfwftd")
    public suspend fun databaseType(`value`: Output<Either<String, SAPDatabaseType>>) {
        this.databaseType = value
    }

    /**
     * @param value Gets or sets the disk configuration.
     */
    @JvmName("bdbghmsgwbfehhmd")
    public suspend fun dbDiskConfiguration(`value`: Output<DiskConfigurationArgs>) {
        this.dbDiskConfiguration = value
    }

    /**
     * @param value The type of SAP deployment, single server or Three tier.
     * Expected value is 'SingleServer'.
     */
    @JvmName("godnfltkukhkwkvy")
    public suspend fun deploymentType(`value`: Output<String>) {
        this.deploymentType = value
    }

    /**
     * @param value Network configuration for the server
     */
    @JvmName("dsvodaxdnsjdeyaq")
    public suspend fun networkConfiguration(`value`: Output<NetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The subnet id.
     */
    @JvmName("hafiovuvoyfoitna")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Gets or sets the virtual machine configuration.
     */
    @JvmName("vrnbiowvjtseekci")
    public suspend fun virtualMachineConfiguration(`value`: Output<VirtualMachineConfigurationArgs>) {
        this.virtualMachineConfiguration = value
    }

    /**
     * @param value The application resource group where SAP system resources will be deployed.
     */
    @JvmName("svrhsigikxeqmqpv")
    public suspend fun appResourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appResourceGroup = mapped
    }

    /**
     * @param value The set of custom names to be used for underlying azure resources that are part of the SAP system.
     */
    @JvmName("hpkocimsnuyayfpw")
    public suspend fun customResourceNames(`value`: SingleServerFullResourceNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResourceNames = mapped
    }

    /**
     * @param argument The set of custom names to be used for underlying azure resources that are part of the SAP system.
     */
    @JvmName("sptjibtgxqjdniee")
    public suspend fun customResourceNames(argument: suspend SingleServerFullResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = SingleServerFullResourceNamesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customResourceNames = mapped
    }

    /**
     * @param value The database type.
     */
    @JvmName("ffaodbsnogrxqoar")
    public suspend fun databaseType(`value`: Either<String, SAPDatabaseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value The database type.
     */
    @JvmName("bcqsyyytipnxuvqq")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value The database type.
     */
    @JvmName("aikqudtjrrlqdaoy")
    public fun databaseType(`value`: SAPDatabaseType) {
        val toBeMapped = Either.ofRight<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value Gets or sets the disk configuration.
     */
    @JvmName("kpahrppahgvxxbbp")
    public suspend fun dbDiskConfiguration(`value`: DiskConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbDiskConfiguration = mapped
    }

    /**
     * @param argument Gets or sets the disk configuration.
     */
    @JvmName("ctfejqsoppteevwh")
    public suspend fun dbDiskConfiguration(argument: suspend DiskConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DiskConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dbDiskConfiguration = mapped
    }

    /**
     * @param value The type of SAP deployment, single server or Three tier.
     * Expected value is 'SingleServer'.
     */
    @JvmName("gmprqelvgltleuap")
    public suspend fun deploymentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value Network configuration for the server
     */
    @JvmName("scfuhjjushwamxdf")
    public suspend fun networkConfiguration(`value`: NetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Network configuration for the server
     */
    @JvmName("wpfbxcpjgmhagdjr")
    public suspend fun networkConfiguration(argument: suspend NetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The subnet id.
     */
    @JvmName("vhsflitivrnwexwl")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Gets or sets the virtual machine configuration.
     */
    @JvmName("gsxpdoremfkggdpw")
    public suspend fun virtualMachineConfiguration(`value`: VirtualMachineConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachineConfiguration = mapped
    }

    /**
     * @param argument Gets or sets the virtual machine configuration.
     */
    @JvmName("tieiymynfpfoceib")
    public suspend fun virtualMachineConfiguration(argument: suspend VirtualMachineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachineConfiguration = mapped
    }

    internal fun build(): SingleServerConfigurationArgs = SingleServerConfigurationArgs(
        appResourceGroup = appResourceGroup ?: throw PulumiNullFieldException("appResourceGroup"),
        customResourceNames = customResourceNames,
        databaseType = databaseType,
        dbDiskConfiguration = dbDiskConfiguration,
        deploymentType = deploymentType ?: throw PulumiNullFieldException("deploymentType"),
        networkConfiguration = networkConfiguration,
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
        virtualMachineConfiguration = virtualMachineConfiguration ?: throw
            PulumiNullFieldException("virtualMachineConfiguration"),
    )
}
