@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SshKeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
 * @property privateKey SSH private key.
 * @property publicKey SSH public key
 */
public data class SshKeyPairArgs(
    public val privateKey: Output<String>? = null,
    public val publicKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SshKeyPairArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SshKeyPairArgs =
        com.pulumi.azurenative.workloads.inputs.SshKeyPairArgs.builder()
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SshKeyPairArgs].
 */
@PulumiTagMarker
public class SshKeyPairArgsBuilder internal constructor() {
    private var privateKey: Output<String>? = null

    private var publicKey: Output<String>? = null

    /**
     * @param value SSH private key.
     */
    @JvmName("bwguodtfqdarlvjr")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value SSH public key
     */
    @JvmName("kcxvahrgmmnskarw")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value SSH private key.
     */
    @JvmName("qcpyphbapfebgkga")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value SSH public key
     */
    @JvmName("ebwwbrrhpihssjiq")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    internal fun build(): SshKeyPairArgs = SshKeyPairArgs(
        privateKey = privateKey,
        publicKey = publicKey,
    )
}
