@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.UserAssignedServiceIdentityArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit the ACSS how-to-guide.
 * @property type Type of manage identity
 * @property userAssignedIdentities User assigned identities dictionary
 */
public data class UserAssignedServiceIdentityArgs(
    public val type: Output<Either<String, ManagedServiceIdentityType>>,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.UserAssignedServiceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.UserAssignedServiceIdentityArgs =
        com.pulumi.azurenative.workloads.inputs.UserAssignedServiceIdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [UserAssignedServiceIdentityArgs].
 */
@PulumiTagMarker
public class UserAssignedServiceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedServiceIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Type of manage identity
     */
    @JvmName("ugnemnyhjrxxjale")
    public suspend fun type(`value`: Output<Either<String, ManagedServiceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value User assigned identities dictionary
     */
    @JvmName("qjinlkqwqupahuex")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("xdwmiruacoihwfru")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values User assigned identities dictionary
     */
    @JvmName("giwehgyyynnwawfn")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Type of manage identity
     */
    @JvmName("kyohrrpfvnxbrojf")
    public suspend fun type(`value`: Either<String, ManagedServiceIdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of manage identity
     */
    @JvmName("hlfkvktyfagaxfpj")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of manage identity
     */
    @JvmName("tsykxveysdmvxqgt")
    public fun type(`value`: ManagedServiceIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User assigned identities dictionary
     */
    @JvmName("efoobsuhbtvsohdd")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values User assigned identities dictionary
     */
    @JvmName("lndfwooexnlujixb")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): UserAssignedServiceIdentityArgs = UserAssignedServiceIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
