@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.VirtualMachineResourceNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The resource names object for virtual machine and related resources.
 * @property dataDiskNames The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
 * @property hostName The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than or equal to 13 characters long. If this value is not provided, vmName will be used as host name.
 * @property networkInterfaces The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
 * @property osDiskName The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk attached per Virtual Machine.
 * @property vmName The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer. For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
 */
public data class VirtualMachineResourceNamesArgs(
    public val dataDiskNames: Output<Map<String, List<String>>>? = null,
    public val hostName: Output<String>? = null,
    public val networkInterfaces: Output<List<NetworkInterfaceResourceNamesArgs>>? = null,
    public val osDiskName: Output<String>? = null,
    public val vmName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.VirtualMachineResourceNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.VirtualMachineResourceNamesArgs =
        com.pulumi.azurenative.workloads.inputs.VirtualMachineResourceNamesArgs.builder()
            .dataDiskNames(
                dataDiskNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.map({ args0 -> args0 }))
                    }).toMap()
                }),
            )
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osDiskName(osDiskName?.applyValue({ args0 -> args0 }))
            .vmName(vmName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineResourceNamesArgs].
 */
@PulumiTagMarker
public class VirtualMachineResourceNamesArgsBuilder internal constructor() {
    private var dataDiskNames: Output<Map<String, List<String>>>? = null

    private var hostName: Output<String>? = null

    private var networkInterfaces: Output<List<NetworkInterfaceResourceNamesArgs>>? = null

    private var osDiskName: Output<String>? = null

    private var vmName: Output<String>? = null

    /**
     * @param value The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
     */
    @JvmName("pglhtxorkmtxkydg")
    public suspend fun dataDiskNames(`value`: Output<Map<String, List<String>>>) {
        this.dataDiskNames = value
    }

    /**
     * @param value The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than or equal to 13 characters long. If this value is not provided, vmName will be used as host name.
     */
    @JvmName("wwngoyygwvetumig")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
     */
    @JvmName("lppnousgmhsgpjqy")
    public suspend fun networkInterfaces(`value`: Output<List<NetworkInterfaceResourceNamesArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("cpldtghssmdidqls")
    public suspend fun networkInterfaces(vararg values: Output<NetworkInterfaceResourceNamesArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
     */
    @JvmName("wsdphtlkmefsosao")
    public suspend fun networkInterfaces(values: List<Output<NetworkInterfaceResourceNamesArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk attached per Virtual Machine.
     */
    @JvmName("txexgbywsvjcvsyx")
    public suspend fun osDiskName(`value`: Output<String>) {
        this.osDiskName = value
    }

    /**
     * @param value The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer. For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
     */
    @JvmName("mnxrqajeoeffecjq")
    public suspend fun vmName(`value`: Output<String>) {
        this.vmName = value
    }

    /**
     * @param value The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
     */
    @JvmName("dhmmemtrbijgseiv")
    public suspend fun dataDiskNames(`value`: Map<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskNames = mapped
    }

    /**
     * @param values The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
     */
    @JvmName("dfbqpefhtfqvuplu")
    public fun dataDiskNames(vararg values: Pair<String, List<String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDiskNames = mapped
    }

    /**
     * @param value The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than or equal to 13 characters long. If this value is not provided, vmName will be used as host name.
     */
    @JvmName("aullorsdthqchhlp")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
     */
    @JvmName("qwowkelitslklvhx")
    public suspend fun networkInterfaces(`value`: List<NetworkInterfaceResourceNamesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
     */
    @JvmName("dqqkppydmjmhvhct")
    public suspend fun networkInterfaces(argument: List<suspend NetworkInterfaceResourceNamesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceResourceNamesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
     */
    @JvmName("bvterwbtaamvbogq")
    public suspend fun networkInterfaces(vararg argument: suspend NetworkInterfaceResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceResourceNamesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
     */
    @JvmName("fchabbtgcbujrbaw")
    public suspend fun networkInterfaces(argument: suspend NetworkInterfaceResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkInterfaceResourceNamesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
     */
    @JvmName("lyeanhnnpuiobyym")
    public suspend fun networkInterfaces(vararg values: NetworkInterfaceResourceNamesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk attached per Virtual Machine.
     */
    @JvmName("wqjfatnwxpskfjxw")
    public suspend fun osDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDiskName = mapped
    }

    /**
     * @param value The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer. For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
     */
    @JvmName("fbawciebeebrfhxn")
    public suspend fun vmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmName = mapped
    }

    internal fun build(): VirtualMachineResourceNamesArgs = VirtualMachineResourceNamesArgs(
        dataDiskNames = dataDiskNames,
        hostName = hostName,
        networkInterfaces = networkInterfaces,
        osDiskName = osDiskName,
        vmName = vmName,
    )
}
