@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.WindowsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies Windows operating system settings on the virtual machine.
 * @property osType The OS Type
 * Expected value is 'Windows'.
 */
public data class WindowsConfigurationArgs(
    public val osType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.WindowsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.WindowsConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.WindowsConfigurationArgs.builder()
            .osType(osType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsConfigurationArgs].
 */
@PulumiTagMarker
public class WindowsConfigurationArgsBuilder internal constructor() {
    private var osType: Output<String>? = null

    /**
     * @param value The OS Type
     * Expected value is 'Windows'.
     */
    @JvmName("pxbdrmhtmwhffdlj")
    public suspend fun osType(`value`: Output<String>) {
        this.osType = value
    }

    /**
     * @param value The OS Type
     * Expected value is 'Windows'.
     */
    @JvmName("pdjnobnyasgosihe")
    public suspend fun osType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    internal fun build(): WindowsConfigurationArgs = WindowsConfigurationArgs(
        osType = osType ?: throw PulumiNullFieldException("osType"),
    )
}
