@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the application server configuration.
 * @property instanceCount The number of app server instances.
 * @property subnetId The subnet id.
 * @property virtualMachineConfiguration Gets or sets the virtual machine configuration.
 */
public data class ApplicationServerConfigurationResponse(
    public val instanceCount: Double,
    public val subnetId: String,
    public val virtualMachineConfiguration: VirtualMachineConfigurationResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ApplicationServerConfigurationResponse): ApplicationServerConfigurationResponse = ApplicationServerConfigurationResponse(
            instanceCount = javaType.instanceCount(),
            subnetId = javaType.subnetId(),
            virtualMachineConfiguration = javaType.virtualMachineConfiguration().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.VirtualMachineConfigurationResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
